/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.core.common;

import cn.sylinx.horm.dialect.Dialect;
import cn.sylinx.horm.type.TypeHandlerRegistry;
import cn.sylinx.horm.type.handler.TypeHandler;
import cn.sylinx.horm.type.handler.UnknownTypeHandler;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class OrmUtil {
    public static void setParameter(Dialect dialect, PreparedStatement pst, int index, Object param) throws SQLException {
        UnknownTypeHandler handler;
        TypeHandler<Object> typeHandler = handler = param == null ? TypeHandlerRegistry.getInstance().getUnknownTypeHandler() : OrmUtil.getTypeHandler(dialect, param.getClass());
        if (handler != null) {
            handler.setParameter(pst, index, param);
        } else {
            pst.setObject(index, param);
        }
    }

    public static <T> T getResult(Dialect dialect, ResultSet rs, String columnName, Class<T> clz) throws SQLException {
        TypeHandler<T> handler = OrmUtil.getTypeHandler(dialect, clz);
        if (handler != null) {
            return handler.getResult(rs, columnName);
        }
        return (T)rs.getObject(columnName);
    }

    public static <T> T getResult(Dialect dialect, ResultSet rs, int columnIndex, Class<T> clz) throws SQLException {
        TypeHandler<T> handler = OrmUtil.getTypeHandler(dialect, clz);
        if (handler != null) {
            return handler.getResult(rs, columnIndex);
        }
        return (T)rs.getObject(columnIndex);
    }

    public static <T> T getResult(Dialect dialect, CallableStatement cs, int columnIndex, Class<T> clz) throws SQLException {
        TypeHandler<T> handler = OrmUtil.getTypeHandler(dialect, clz);
        if (handler != null) {
            return handler.getResult(cs, columnIndex);
        }
        return (T)cs.getObject(columnIndex);
    }

    private static <T> TypeHandler<T> getTypeHandler(Dialect dialect, Class<T> clz) {
        TypeHandler<T> handlerDialect = dialect == null ? null : dialect.crateTypeHandler(clz);
        TypeHandler<T> handler = handlerDialect == null ? TypeHandlerRegistry.getInstance().getTypeHandler(clz) : handlerDialect;
        return handler;
    }
}

