/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.config;

import cn.sylinx.horm.config.CacheLoader;
import cn.sylinx.horm.config.CommandLoader;
import cn.sylinx.horm.config.MapStrategyLoader;
import cn.sylinx.horm.config.MapperLoader;
import cn.sylinx.horm.config.ModelCacheLoader;
import cn.sylinx.horm.config.OrmConfig;
import cn.sylinx.horm.config.ServiceEnvironment;
import cn.sylinx.horm.config.SqlResourceLoader;
import cn.sylinx.horm.config.TransactionIsolationLoader;
import cn.sylinx.horm.core.stat.SqlStatManager;
import cn.sylinx.horm.util.GLog;
import java.util.concurrent.atomic.AtomicBoolean;

public enum OrmConfigHolder {

    private static final AtomicBoolean inited = new AtomicBoolean(false);
    private static OrmConfig ormConfig = new OrmConfig();
    private static ServiceEnvironment serviceEnvironment = ServiceEnvironment.NORMAL;

    public static synchronized void init(ServiceEnvironment serviceEnvironment, OrmConfig ormConfig) {
        if (inited.get()) {
            GLog.info("\u5df2\u521d\u59cb\u5316", new Object[0]);
            return;
        }
        try {
            OrmConfigHolder.initInner(serviceEnvironment, ormConfig);
        }
        finally {
            inited.set(true);
        }
    }

    private static void initInner(ServiceEnvironment serviceEnvironment, OrmConfig ormConfig) {
        OrmConfigHolder.serviceEnvironment = serviceEnvironment;
        try {
            OrmConfigHolder.ormConfig = (OrmConfig)ormConfig.clone();
        }
        catch (CloneNotSupportedException e) {
            GLog.error("OrmConfig clone error", e);
            return;
        }
        OrmConfigHolder.initConfig();
        GLog.info("\u914d\u7f6e\u521d\u59cb\u5316\u6210\u529f, OrmConifg:{}", OrmConfigHolder.ormConfig);
    }

    private static void initConfig() {
        if (!OrmConfigHolder.isDebug() && OrmConfigHolder.isCache()) {
            new CacheLoader(ormConfig).initCache();
        }
        if (!OrmConfigHolder.isDebug()) {
            new SqlResourceLoader(ormConfig).load();
        }
        if (OrmConfigHolder.isNormalJavaEnv()) {
            new CommandLoader(ormConfig).load();
            new MapperLoader(ormConfig).load();
            new TransactionIsolationLoader(ormConfig).load();
        }
        new MapStrategyLoader(ormConfig).load();
        if (OrmConfigHolder.isNormalJavaEnv() && !OrmConfigHolder.isDebug() && ormConfig.isCacheModelOnStart()) {
            new ModelCacheLoader(ormConfig).load();
        }
        if (OrmConfigHolder.isSqlStatOpen()) {
            SqlStatManager.start();
        }
    }

    private static boolean isNormalJavaEnv() {
        return ServiceEnvironment.NORMAL == serviceEnvironment;
    }

    public static ServiceEnvironment getServiceEnvironment() {
        return serviceEnvironment;
    }

    public static boolean isDebug() {
        return ormConfig.isDebug();
    }

    public static boolean isSqlStatOpen() {
        return ormConfig.isSqlStatOpen() && ormConfig.getSqlExecuteTimeThreshold() > 100L;
    }

    public static boolean isCache() {
        return ormConfig.isCache();
    }

    public static boolean isOptimisticLockEnable() {
        return ormConfig.isOptimisticLockEnable();
    }

    public static boolean isCaseSensitive() {
        return ormConfig.isCaseSensitive();
    }

    public static long getSqlExecuteTimeThreshold() {
        return ormConfig.getSqlExecuteTimeThreshold();
    }
}

