package cn.sylinx.horm.spring.scan;

import org.springframework.beans.factory.FactoryBean;

import cn.sylinx.horm.proxy.mapper.registrar.MapperContainer;

public class MapperFactoryBean<T> implements FactoryBean<T> {
	
	private Class<T>  mapperInterface;

	public MapperFactoryBean() {
	}

	public MapperFactoryBean(Class<T> mapperInterface) {
		this.mapperInterface = mapperInterface;
	}

	@Override
	public T getObject() throws Exception {
		return MapperContainer.getMapper(mapperInterface);
	}

	@Override
	public Class<?> getObjectType() {
		return mapperInterface;
	}
}