package cn.sylinx.horm.spring.scan;

import org.springframework.beans.factory.FactoryBean;

import cn.sylinx.horm.proxy.ProxyObjectRegistry;

public class CommandFactoryBean<T> implements FactoryBean<T> {
	
	private Class<T> commandInterface;

	public CommandFactoryBean() {
	}

	public CommandFactoryBean(Class<T> commandInterface) {
		this.commandInterface = commandInterface;
	}

	@Override
	public T getObject() throws Exception {
		return ProxyObjectRegistry.INSTANCE.getCommand(commandInterface);
	}

	@Override
	public Class<?> getObjectType() {
		return commandInterface;
	}
}