package cn.sylinx.horm.spring.config;

import java.util.List;
import java.util.Map;

import cn.sylinx.horm.dialect.EnumDbType;

public class DataSourceConfig implements Cloneable {
	
	// 自行创建数据源，不用spring数据源
	private boolean useNative = false;
	
	private boolean multiple = false; // 是否多数据源
	
	// 数据库类型，使用单数据源时有效
	private String defaultDbtype = EnumDbType.MYSQL.getValue();
	private String defaultUrl;
	private String defaultDriver;
	private String defaultUsername;
	private String defaultPassword;
	private String defaultPooltype;
	private Map<String,Object> defaultPoolConfig;
	
	private List<SingleDataSourceConfig> multids;

	public boolean isMultiple() {
		return multiple;
	}

	public void setMultiple(boolean multiple) {
		this.multiple = multiple;
	}

	public List<SingleDataSourceConfig> getMultids() {
		return multids;
	}

	public void setMultids(List<SingleDataSourceConfig> multids) {
		this.multids = multids;
	}

	public String getDefaultDbtype() {
		return defaultDbtype;
	}

	public void setDefaultDbtype(String defaultDbtype) {
		this.defaultDbtype = defaultDbtype;
	}

	public String getDefaultUrl() {
		return defaultUrl;
	}

	public void setDefaultUrl(String defaultUrl) {
		this.defaultUrl = defaultUrl;
	}

	public String getDefaultDriver() {
		return defaultDriver;
	}

	public void setDefaultDriver(String defaultDriver) {
		this.defaultDriver = defaultDriver;
	}

	public String getDefaultUsername() {
		return defaultUsername;
	}

	public void setDefaultUsername(String defaultUsername) {
		this.defaultUsername = defaultUsername;
	}

	public String getDefaultPassword() {
		return defaultPassword;
	}

	public void setDefaultPassword(String defaultPassword) {
		this.defaultPassword = defaultPassword;
	}

	public String getDefaultPooltype() {
		return defaultPooltype;
	}

	public void setDefaultPooltype(String defaultPooltype) {
		this.defaultPooltype = defaultPooltype;
	}

	public Map<String, Object> getDefaultPoolConfig() {
		return defaultPoolConfig;
	}

	public void setDefaultPoolConfig(Map<String, Object> defaultPoolConfig) {
		this.defaultPoolConfig = defaultPoolConfig;
	}

	public boolean isUseNative() {
		return useNative;
	}

	public void setUseNative(boolean useNative) {
		this.useNative = useNative;
	}

	@Override
	public String toString() {
		return "DataSourceConfig [useNative=" + useNative + ", multiple=" + multiple + ", defaultDbtype="
				+ defaultDbtype + ", defaultUrl=" + defaultUrl + ", defaultDriver=" + defaultDriver
				+ ", defaultUsername=" + defaultUsername + ", defaultPassword=" + defaultPassword + ", defaultPooltype="
				+ defaultPooltype + ", defaultPoolConfig=" + defaultPoolConfig + ", multids=" + multids + "]";
	}
	
}