package cn.sylinx.horm.resource.parse;

import java.util.Map;

import cn.sylinx.horm.dialect.DbType;
import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.resource.ClasspathSqlResource;
import cn.sylinx.horm.resource.ClasspathSqlResourceManager;
import cn.sylinx.horm.resource.StatementHandler;
import cn.sylinx.horm.util.GLog;
import cn.sylinx.horm.util.Pair;
import cn.sylinx.horm.util.StrKit;

public class SqlParser {

	public static final String SQL_POSTFIX = ".sql";

	// 数据库类型，用来解析不同数据库类型的sql resource
	private DbType dbtype;

	public SqlParser() {
	}

	public SqlParser(DbType dbtype) {
		this.dbtype = dbtype;
	}
	
	public DbType getDbtype() {
		return dbtype;
	}

	public void setDbtype(DbType dbtype) {
		this.dbtype = dbtype;
	}

	public Pair parseSql(ClasspathSqlResource sqlResource, Map<String, Object> params) {
		String statement = ClasspathSqlResourceManager.getStatement(parseTruelySqlpath(sqlResource.getSqlpath()));
		if (StrKit.isBlank(statement)) {
			throw new HORMException("SQL语句为空, 资源:" + sqlResource.getSqlpath());
		}
		return parseSql(statement, params, sqlResource.isFormat(), sqlResource.getStatementHandler());
	}

	protected String parseTruelySqlpath(String sqlpath) {

		if (dbtype == null) {
			return sqlpath;
		}

		String dbtypePostfix = "." + dbtype.getValue() + SQL_POSTFIX;
		int indexExist = sqlpath.lastIndexOf(dbtypePostfix);
		if (indexExist > 0) {
			return sqlpath;
		}

		int index = sqlpath.lastIndexOf(SQL_POSTFIX);
		if (index < 1) {
			throw new HORMException("invalid sql resource file");
		}

		return sqlpath.substring(0, index) + dbtypePostfix;
	}

	public Pair parseSql(String statement, Map<String, Object> params, StatementHandler sqlHandler) {
		return parseSql(statement, params, true, sqlHandler);
	}

	public Pair parseSql(String statement, Map<String, Object> params) {
		return parseSql(statement, params, null);
	}

	public Pair parseSql(String statement, Map<String, Object> params, boolean format, StatementHandler sqlHandler) {
		TokenHandler handler = createWithParameterMap(params);
		GenericTokenParser gt = new GenericTokenParser(handler);
		Pair tp = gt.parse(statement, format);
		if (sqlHandler != null) {
			String statementReplace = sqlHandler.handle(tp.getObject(0, String.class));
			GLog.debug("changed sql: " + statementReplace);
			return Pair.apply(statementReplace, tp.get(1));
		}
		return tp;
	}

	private TokenHandler createWithParameterMap(Map<String, Object> params) {
		TokenHandler handler = TokenHandler.create();
		handler.setParameterMap(params);
		return handler;
	}

}