package cn.sylinx.horm.resource.func.impl;

import cn.sylinx.horm.resource.func.IFunction;
import cn.sylinx.horm.resource.parse.TokenHandler;
import cn.sylinx.horm.resource.parse.ValueTokenHandler;
import cn.sylinx.horm.util.GLog;
import ognl.Ognl;
import ognl.OgnlException;

/**
 * ognl表达式<br>
 * 使用方法 #FUNC[ognl,express]<br>
 * 
 * @author han
 *
 */
public class OgnlFunction implements IFunction {

	@Override
	public String sqlAlias() {
		return "ognl";
	}

	@Override
	public String invoke(ValueTokenHandler valueTokenHandler, String input) {

		Object root = null;
		if (valueTokenHandler != null && (valueTokenHandler instanceof TokenHandler)) {
			root = ((TokenHandler) valueTokenHandler).getParameterMap();
		}

		try {
			String trimmedInput = input.trim();
			return String.valueOf(Ognl.getValue(trimmedInput, root));
		} catch (OgnlException e) {
			GLog.error("OgnlFunction error:" + e.getMessage(), e);
		}

		return "";
	}

}
