package cn.sylinx.horm.resource.block;

import java.util.ArrayList;
import java.util.List;

class IF implements PreNode {

	private int index;

	private int nextIndex;

	private String condition;

	private List<IfEndBlock> ifEndBlockList = new ArrayList<IfEndBlock>();;

	private String contentPattern;

	/**
	 * ELSIF or ELSE
	 */
	private FollowNode followNode;

	public String getNodeName() {
		return Tags.KW_IF;
	}

	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("{");
		sb.append("IF NODE(");
		sb.append("index:").append(index).append(",");
		sb.append("nextIndex:").append(nextIndex).append(",");
		sb.append("condition:").append(condition).append(",");
		sb.append("contentPattern:").append(contentPattern).append(",");
		sb.append("followNode:").append(followNode).append(",");
		sb.append("ifEndBlockList:").append("[");
		for (IfEndBlock item : ifEndBlockList) {
			sb.append(item.toString()).append(",");
		}
		sb.append("]");
		sb.append(")");
		sb.append("}");

		return sb.toString();
	}

	public List<IfEndBlock> getIfEndBlockList() {
		return ifEndBlockList;
	}

	public int getNextIndex() {
		return nextIndex;
	}

	public void setNextIndex(int nextIndex) {
		this.nextIndex = nextIndex;
	}

	public int getIndex() {
		return index;
	}

	public void setIndex(int index) {
		this.index = index;
	}

	public void addIfEndBlock(IfEndBlock ifEndBlock) {
		ifEndBlockList.add(ifEndBlock);
	}

	public String getCondition() {
		return condition;
	}

	public void setCondition(String condition) {
		this.condition = condition;
	}

	public String getContentPattern() {
		return contentPattern;
	}

	public void setContentPattern(String contentPattern) {
		this.contentPattern = contentPattern;
	}

	public FollowNode getFollowNode() {
		return followNode;
	}

	public void setFollowNode(FollowNode followNode) {
		this.followNode = followNode;
	}

}
