package cn.sylinx.horm.resource.block;

import java.util.ArrayList;
import java.util.List;

class ELSE implements FollowNode, PreNode {

	private int index;

	private int nextIndex;

	private List<IfEndBlock> ifEndBlockList = new ArrayList<IfEndBlock>();

	private String contentPattern;

	/**
	 * 前置 IF ELSIF
	 */
	private PreNode preNode;

	private END endNode;

	public String getNodeName() {
		return Tags.KW_ELSE;
	}

	public String toString() {

		StringBuilder sb = new StringBuilder();
		sb.append("{");
		sb.append("ELSE NODE(");
		sb.append("index:").append(index).append(",");
		sb.append("nextIndex:").append(nextIndex).append(",");
		sb.append("contentPattern:").append(contentPattern).append(",");
		sb.append("ifEndBlockList:").append("[");
		for (IfEndBlock item : ifEndBlockList) {
			sb.append(item.toString()).append(",");
		}
		sb.append("]");
		sb.append(")");
		sb.append("}");

		return sb.toString();
	}

	public END getEndNode() {
		return endNode;
	}

	public void setEndNode(END endNode) {
		this.endNode = endNode;
	}

	public int getNextIndex() {
		return nextIndex;
	}

	public void setNextIndex(int nextIndex) {
		this.nextIndex = nextIndex;
	}

	public int getIndex() {
		return index;
	}

	public void setIndex(int index) {
		this.index = index;
	}

	public void addIfEndBlock(IfEndBlock ifEndBlock) {
		ifEndBlockList.add(ifEndBlock);
	}

	public String getContentPattern() {
		return contentPattern;
	}

	public void setContentPattern(String contentPattern) {
		this.contentPattern = contentPattern;
	}

	public PreNode getPreNode() {
		return preNode;
	}

	public void setPreNode(PreNode preNode) {
		this.preNode = preNode;
	}

	public List<IfEndBlock> getIfEndBlockList() {
		return ifEndBlockList;
	}

}
