
package cn.sylinx.horm.model.cache;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

public class ModelCacheUtil {

	public static List<Field> getObjectAllFieldsWithcache(Class<?> cclz) {
		return getModelFabric(cclz).getFields();
	}

	/**
	 * 获取乐观锁字段
	 * 
	 * @param cclz
	 * @return
	 */
	public static Field getVersionField(Class<?> cclz) {
		return getModelFabric(cclz).getVersionField();
	}

	public static Map<String, Field> getObjectAllFieldsMapWithcache(Class<?> cclz) {
		return getModelFabric(cclz).getFieldMap();
	}

	public static ModelFabric getModelFabric(String clzStr) {
		return ModelCacheManager.getModelFabric(clzStr);

	}

	public static ModelFabric getModelFabric(Class<?> clz) {
		return ModelCacheManager.getModelFabric(clz);
	}

	public static String buildColumnsByExcluded(Class<?> clz, List<String> excludedColumns) {

		ModelFabric mf = getModelFabric(clz);
		Map<String, String> attrs = mf.getAttrMapping();
		Set<String> columns = new HashSet<String>();
		Set<Entry<String, String>> kvsets = attrs.entrySet();
		for (Entry<String, String> entry : kvsets) {
			if (excludedColumns.contains(entry.getKey()) || excludedColumns.contains(entry.getValue())
					|| excludedColumns.contains(entry.getValue().toLowerCase())) {
				continue;
			}
			columns.add(entry.getValue().toUpperCase());
		}

		StringBuilder sb = new StringBuilder();
		columns.forEach(k -> sb.append(k).append(","));
		if (sb.length() > 0) {
			sb.deleteCharAt(sb.length() - 1);
		}
		return sb.toString();
	}
}
