package cn.sylinx.horm.config;

import java.sql.Connection;

import cn.sylinx.horm.cache.impl.GuavaCacheConfig;
import cn.sylinx.horm.model.strategy.Strategy;
import cn.sylinx.horm.util.StrKit;

/**
 * 配置相关
 * 
 * @author johnhan
 *
 */
public class OrmConfig implements Cloneable {

	public static final String DEFAULT_MAPPER_POST_FIX = ".mapper.xml";
	public static final String DEFAULT_SQL_POST_FIX = ".resource.sql";
	// 慢SQL 100毫秒探测1次
	public static final long DEFAULT_STAT_INTERNAL = 100L;
	// 慢SQL 默认阈值3秒
	public static final long DEFAULT_STAT_THRESHOLD = 3000L;
	
	// 是否启用调试
	private boolean debug = false;

	// 是否启用缓存
	private boolean cache = false;

	// 是否大小写敏感，默认不敏感
	private boolean caseSensitive = false;

	// guava cache 配置
	private GuavaCacheConfig guavaCacheConfig;

	// sql资源文件
	private String sqlPath;

	// sql资源 匹配后缀
	private String sqlPostfix = DEFAULT_SQL_POST_FIX;

	// 乐观锁是否启用
	private boolean optimisticLockEnable = false;

	// command 扫描包（Springboot环境下无需手动指定）
	private String commandScanPackage;

	// mapper 扫描包（Springboot环境下无需手动指定）
	private String mapperScanPackage;

	// mapper 匹配后缀
	private String mapperPostfix = DEFAULT_MAPPER_POST_FIX;

	// 模型映射策略，underline ｜ attr （下划线、属性一致）
	private String modelMapStrategy = Strategy.STRATEGY_UNDERLINE;

	// jdbc 事务隔离级别，普通java项目中可设置
	private int transactionIsolation = Connection.TRANSACTION_READ_COMMITTED;

	// 是否使用jdbc本地事务，只有在非ServiceEnvironment.NORMAL环境有效
	private boolean transactionNative = false;

	// 解析sql资源是否区分数据库类型，默认否
	private boolean parseSqlPathDbtype = false;

	// 启动时加载对有Model注解的实体到缓存
	private boolean cacheModelOnStart = false;

	// 缓存Model扫描包（Springboot环境下无需设置）
	private String modelScanPackage;

	// 是否开启SQL统计
	private boolean sqlStatOpen = false;
	// sql执行超时时间，默认3秒
	private long sqlExecuteTimeThreshold = 3000L;

	public boolean isDebug() {
		return debug;
	}

	public void setDebug(boolean debug) {
		this.debug = debug;
	}

	public boolean isCache() {
		return cache;
	}

	public void setCache(boolean cache) {
		this.cache = cache;
	}

	public GuavaCacheConfig getGuavaCacheConfig() {
		return guavaCacheConfig;
	}

	public void setGuavaCacheConfig(GuavaCacheConfig guavaCacheConfig) {
		this.guavaCacheConfig = guavaCacheConfig;
	}

	public String getSqlPath() {
		return sqlPath;
	}

	public void setSqlPath(String sqlPath) {
		this.sqlPath = sqlPath;
	}

	public String getSqlPostfix() {
		return sqlPostfix;
	}

	public void setSqlPostfix(String sqlPostfix) {

		if (StrKit.isBlank(sqlPostfix)) {
			sqlPostfix = DEFAULT_SQL_POST_FIX;
		}
		this.sqlPostfix = sqlPostfix;
	}

	public boolean isOptimisticLockEnable() {
		return optimisticLockEnable;
	}

	public void setOptimisticLockEnable(boolean optimisticLockEnable) {
		this.optimisticLockEnable = optimisticLockEnable;
	}

	public String getCommandScanPackage() {
		return commandScanPackage;
	}

	public void setCommandScanPackage(String commandScanPackage) {
		this.commandScanPackage = commandScanPackage;
	}

	public String getMapperScanPackage() {
		return mapperScanPackage;
	}

	public void setMapperScanPackage(String mapperScanPackage) {
		this.mapperScanPackage = mapperScanPackage;
	}

	public String getModelMapStrategy() {
		return modelMapStrategy;
	}

	public void setModelMapStrategy(String modelMapStrategy) {
		this.modelMapStrategy = modelMapStrategy;
	}

	public int getTransactionIsolation() {
		return transactionIsolation;
	}

	public void setTransactionIsolation(int transactionIsolation) {
		this.transactionIsolation = transactionIsolation;
	}

	public boolean isParseSqlPathDbtype() {
		return parseSqlPathDbtype;
	}

	public void setParseSqlPathDbtype(boolean parseSqlPathDbtype) {
		this.parseSqlPathDbtype = parseSqlPathDbtype;
	}

	public boolean isCacheModelOnStart() {
		return cacheModelOnStart;
	}

	public void setCacheModelOnStart(boolean cacheModelOnStart) {
		this.cacheModelOnStart = cacheModelOnStart;
	}

	public String getModelScanPackage() {
		return modelScanPackage;
	}

	public void setModelScanPackage(String modelScanPackage) {
		this.modelScanPackage = modelScanPackage;
	}

	public boolean isTransactionNative() {
		return transactionNative;
	}

	public void setTransactionNative(boolean transactionNative) {
		this.transactionNative = transactionNative;
	}

	public String getMapperPostfix() {
		return mapperPostfix;
	}

	public void setMapperPostfix(String mapperPostfix) {
		if (StrKit.isBlank(mapperPostfix)) {
			mapperPostfix = DEFAULT_MAPPER_POST_FIX;
		}
		this.mapperPostfix = mapperPostfix;
	}

	public boolean isCaseSensitive() {
		return caseSensitive;
	}

	public void setCaseSensitive(boolean caseSensitive) {
		this.caseSensitive = caseSensitive;
	}
	
	public boolean isSqlStatOpen() {
		return sqlStatOpen;
	}

	public void setSqlStatOpen(boolean sqlStatOpen) {
		this.sqlStatOpen = sqlStatOpen;
	}

	public long getSqlExecuteTimeThreshold() {
		return sqlExecuteTimeThreshold;
	}

	public void setSqlExecuteTimeThreshold(long sqlExecuteTimeThreshold) {
		this.sqlExecuteTimeThreshold = sqlExecuteTimeThreshold;
	}

	@Override
	protected Object clone() throws CloneNotSupportedException {
		OrmConfig clone = (OrmConfig) super.clone();
		clone.setGuavaCacheConfig(guavaCacheConfig == null ? null : (GuavaCacheConfig) guavaCacheConfig.clone());
		return clone;
	}

	@Override
	public String toString() {
		return "OrmConfig [debug=" + debug + ", cache=" + cache + ", caseSensitive=" + caseSensitive
				+ ", guavaCacheConfig=" + guavaCacheConfig + ", sqlPath=" + sqlPath + ", sqlPostfix=" + sqlPostfix
				+ ", optimisticLockEnable=" + optimisticLockEnable + ", commandScanPackage=" + commandScanPackage
				+ ", mapperScanPackage=" + mapperScanPackage + ", mapperPostfix=" + mapperPostfix
				+ ", modelMapStrategy=" + modelMapStrategy + ", transactionIsolation=" + transactionIsolation
				+ ", transactionNative=" + transactionNative + ", parseSqlPathDbtype=" + parseSqlPathDbtype
				+ ", cacheModelOnStart=" + cacheModelOnStart + ", modelScanPackage=" + modelScanPackage
				+ ", sqlStatOpen=" + sqlStatOpen + "]";
	}

}
