package cn.sylinx.horm.util;

import java.io.Serializable;

@SuppressWarnings("serial")
public class Ret implements Serializable {

	private boolean success = false;

	private String error;

	private Object data;

	private int code = 500;

	private boolean nestedTransaction = false;

	private Throwable cause;

	public Ret() {

	}

	public Ret(boolean success, String error, Object data) {
		this(success, error, data, 500);
	}

	public Ret(boolean success, String error, Object data, int code) {
		this(success, error, data, code, null);
	}

	public Ret(boolean success, String error, Object data, int code, Throwable cause) {
		this.success = success;
		this.error = error;
		this.data = data;
		this.code = code;
		this.cause = cause;
	}

	public static Ret error() {
		return new Ret(false, "执行失败", null, 500);
	}

	public static Ret error(String error) {
		return new Ret(false, error, null, 500);
	}

	public static Ret error(int code, String error) {
		return new Ret(false, error, null, code);
	}

	public static Ret error(int code, String error, Throwable cause) {
		return new Ret(false, error, null, code, cause);
	}

	public static Ret success() {
		return new Ret(true, "成功执行", null, 200);
	}

	public static Ret success(Object data) {
		return new Ret(true, "成功执行", data, 200);
	}

	public static Ret nestedRet(Ret ret) {
		Ret nestedRet = success(ret);
		nestedRet.setNestedTransaction(true);
		return nestedRet;
	}

	public boolean isSuccess() {
		return success;
	}

	public void setSuccess(boolean success) {
		this.success = success;
	}

	public String getError() {
		return error;
	}

	public void setError(String error) {
		this.error = error;
	}

	public Object getData() {
		return data;
	}

	public void setData(Object data) {
		this.data = data;
	}

	public int getCode() {
		return code;
	}

	public void setCode(int code) {
		this.code = code;
	}

	public boolean isNestedTransaction() {
		return nestedTransaction;
	}

	public void setNestedTransaction(boolean nestedTransaction) {
		this.nestedTransaction = nestedTransaction;
	}

	public Throwable getCause() {
		return cause;
	}

	public void setCause(Throwable cause) {
		this.cause = cause;
	}

}
