package cn.sylinx.horm.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * log toolkit
 * 
 * @author han
 *
 */
public class GLog {

	/**
	 * the logger
	 */
	private static final Logger logger = LoggerFactory.getLogger(GLog.class);

	/**
	 * info
	 * 
	 * @param message
	 *            message
	 * @param params
	 *            params
	 */
	public static void info(String message, Object... params) {
		logger.info(message, params);
	}

	/**
	 * debug
	 * 
	 * @param message
	 *            the message
	 * @param params
	 *            the params
	 */
	public static void debug(String message, Object... params) {
		logger.debug(message, params);
	}

	/**
	 * error
	 * 
	 * @param message
	 *            the message
	 * @param t
	 *            the Throwable
	 */
	public static void error(String message, Throwable t) {
		logger.error(message, t);
	}

	public static void error(String message, Object... params) {
		logger.error(message, params);
	}

	public static void warn(String message, Object... params) {
		logger.warn(message, params);
	}
}
