package cn.sylinx.horm.spring.boot;

import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import cn.sylinx.horm.spring.CommandScannerRegistrar;

public class AutoConfiguredCommandScannerRegistrar extends CommandScannerRegistrar implements BeanFactoryAware {
	private BeanFactory beanFactory;

	@Override
	public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
		this.beanFactory = beanFactory;
	}

	@Override
	public List<String> getPackages() {
		return AutoConfigurationPackages.get(this.beanFactory);
	}
}