package cn.sylinx.horm.spring;

import org.springframework.beans.factory.FactoryBean;

import cn.sylinx.horm.proxy.command.CommandRegistry;

public class CommandFactoryBean<T> implements FactoryBean<T> {
	private Class<T> commandInterface;

	public CommandFactoryBean() {
	}

	public CommandFactoryBean(Class<T> commandInterface) {
		this.commandInterface = commandInterface;
	}

	@Override
	public T getObject() throws Exception {
		return CommandRegistry.INSTANCE.getCommand(commandInterface);
	}

	@Override
	public Class<?> getObjectType() {
		return commandInterface;
	}
}