package cn.sylinx.horm.resource.parse;

import java.util.Map;

import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.resource.ClasspathSqlResource;
import cn.sylinx.horm.resource.ClasspathSqlResourceManager;
import cn.sylinx.horm.resource.StatementHandler;
import cn.sylinx.horm.util.GLog;
import cn.sylinx.horm.util.Pair;
import cn.sylinx.horm.util.StrKit;

public enum SqlParser {
	
	;
	
	public static Pair parseSql(ClasspathSqlResource sqlResource, Map<String, Object> params) {
		String statement = ClasspathSqlResourceManager.getStatement(sqlResource.getSqlpath());
		if (StrKit.isBlank(statement)) {
			throw new HORMException("SQL语句为空, 资源:" + sqlResource.getSqlpath());
		}
		return parseSql(statement, params, sqlResource.isFormat(), sqlResource.getStatementHandler());
	}

	public static Pair parseSql(String statement, Map<String, Object> params, StatementHandler sqlHandler) {
		return parseSql(statement, params, true, sqlHandler);
	}

	public static Pair parseSql(String statement, Map<String, Object> params) {
		return parseSql(statement, params, null);
	}

	public static Pair parseSql(String statement, Map<String, Object> params, boolean format,
			StatementHandler sqlHandler) {
		TokenHandler handler = createWithParameterMap(params);
		GenericTokenParser gt = new GenericTokenParser(handler);
		Pair tp = gt.parse(statement, format);
		if (sqlHandler != null) {
			String statementReplace = sqlHandler.handle(tp.getObject(0, String.class));
			GLog.debug("changed sql: " + statementReplace);
			return Pair.apply(statementReplace, tp.get(1));
		}
		return tp;
	}

	private static TokenHandler createWithParameterMap(Map<String, Object> params) {
		TokenHandler handler = TokenHandler.create();
		handler.setParameterMap(params);
		return handler;
	}
}