package cn.sylinx.horm.resource.parse;

import java.util.HashMap;
import java.util.Map;

import cn.sylinx.horm.util.StrKit;

/**
 * 参数构建器
 * 
 * @author han
 *
 */
public class ParamMapBuilder {

	private Map<String, Object> map = new HashMap<>();

	public ParamMapBuilder put(String key, Object value) {
		if(value != null) {
			map.put(key, value);
		}
		return this;
	}

	public ParamMapBuilder like(String key, String value) {
		if (StrKit.isNotBlank(value)) {
			map.put(key, "%" + value + "%");
		}
		return this;
	}

	public ParamMapBuilder likeLeft(String key, String value) {
		if (StrKit.isNotBlank(value)) {
			map.put(key, "%" + value);
		}
		return this;
	}

	public ParamMapBuilder likeRight(String key, String value) {
		if (StrKit.isNotBlank(value)) {
			map.put(key, value + "%");
		}
		return this;
	}

	public Map<String, Object> build() {
		return map;
	}

}
