package cn.sylinx.horm.resource;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

import cn.sylinx.horm.config.OrmConfigHolder;
import cn.sylinx.horm.util.GLog;
import cn.sylinx.horm.util.Resources;

public enum ClasspathSqlResourceManager {
	
	;
	
	private final static Map<String, String> cache = new HashMap<String, String>();

	public static void clear() {
		synchronized (cache) {
			cache.clear();
		}
	}

	public static String get(String sqlpath) {
		InputStream is = null;
		ByteArrayOutputStream baos = null;
		String statement = null;
		try {
			is = Resources.getResourceAsStream(sqlpath);
			if (is != null) {
				baos = new ByteArrayOutputStream();
				int i = -1;
				while ((i = is.read()) != -1) {
					baos.write(i);
				}
				statement = baos.toString();
			}
		} catch (Exception e) {
			GLog.error("sql resource not found: {}", sqlpath);
			statement = null;
		} finally {
			if (is != null) {
				try {
					is.close();
				} catch (IOException e) {
				}
			}
			if (baos != null) {
				try {
					baos.close();
				} catch (IOException e) {
				}
			}
		}
		return statement;
	}

	public static String loadAndGet(String sqlpath) {
		String statement = get(sqlpath);
		if (statement != null) {
			cache.put(sqlpath, statement);
		}
		return statement;
	}

	public static String getStatement(String sqlpath) {
		if (OrmConfigHolder.isDebug()) {
			// 如果是调试模式，直接从文件中取
			return get(sqlpath);
		}
		if (cache.containsKey(sqlpath)) {
			GLog.debug("sql bingo: {}", sqlpath);
			return cache.get(sqlpath);
		}
		return loadAndGet(sqlpath);
	}
}