package cn.sylinx.horm.proxy.invoker;

import java.util.Map;
import cn.sylinx.horm.core.SqlClient;
import cn.sylinx.horm.resource.ClasspathSqlResource;
import cn.sylinx.horm.resource.parse.SqlParser;
import cn.sylinx.horm.util.ExceptionCatcher;
import cn.sylinx.horm.util.Tuple;

/**
 * 执行（插入、更新、ddl）
 * 
 * @author han
 *
 */
public class ExecuteCommandInvoker extends AbstractCommandInvoker {
	
	private String nativeSql;

	public ExecuteCommandInvoker(String truelyDatasource, String sql, Map<String, Object> params, String nativeSql) {
		super(truelyDatasource, sql, params);
		this.nativeSql = nativeSql;
	}

	@Override
	public Object invoke() {
		SqlClient ormClient = getClient(truelyDatasource);
		// 使用native sql
		boolean isNativeSql = nativeSql != null && !"".equals(nativeSql.trim());
		if (isNativeSql) {
			Tuple t = SqlParser.parseSql(nativeSql, params, null);
			String truelyNativeSql = t.getObject(0);
			Object[] truelyParams = t.getObject(1);
			return ExceptionCatcher.call(() -> ormClient.execute(truelyNativeSql, truelyParams));
		}
		return ormClient.execute(new ClasspathSqlResource(sql), params);
	}
}