package cn.sylinx.horm.proxy.invoker;

import java.util.Map;
import cn.sylinx.horm.core.SqlClient;
import cn.sylinx.horm.resource.ClasspathSqlResource;
import cn.sylinx.horm.resource.parse.SqlParser;
import cn.sylinx.horm.util.Tuple;

/**
 * 返回Bean对象页面
 * 
 * @author han
 *
 */
public class BeanPageCommandInvoker extends AbstractPageCommandInvoker {
	
	private String nativeSql;

	public BeanPageCommandInvoker(String truelyDatasource, String sql, Map<String, Object> params, Integer pageNumber,
			Integer pageSize, Class<?> truelyReturnType, String nativeSql) {
		super(truelyDatasource, sql, params, pageNumber, pageSize, truelyReturnType);
		this.nativeSql = nativeSql;
	}

	@Override
	public Object invoke() {
		SqlClient ormClient = getClient(truelyDatasource);
		// 使用native sql
		boolean isNativeSql = nativeSql != null && !"".equals(nativeSql.trim());
		if (isNativeSql) {
			Tuple t = SqlParser.parseSql(nativeSql, params, null);
			String truelyNativeSql = t.getObject(0);
			Object[] truelyParams = t.getObject(1);
			return ormClient.queryPage(truelyNativeSql, pageNumber, pageSize, truelyParams, truelyReturnType);
		}
		return ormClient.queryPage(new ClasspathSqlResource(sql), pageNumber, pageSize, params, truelyReturnType);
	}
}