package cn.sylinx.horm.proxy.invoker;

import java.util.Map;
import cn.sylinx.horm.core.SqlClient;
import cn.sylinx.horm.resource.ClasspathSqlResource;
import cn.sylinx.horm.resource.parse.SqlParser;
import cn.sylinx.horm.util.Tuple;

/**
 * 返回Bean对象列表
 * 
 * @author han
 *
 */
public class BeanListCommandInvoker extends AbstractQueryListCommandInvoker {
	private String nativeSql;

	public BeanListCommandInvoker(String truelyDatasource, String sql, Map<String, Object> params,
			Class<?> truelyReturnType, String nativeSql) {
		super(truelyDatasource, sql, params, truelyReturnType);
		this.nativeSql = nativeSql;
	}

	@Override
	public Object invoke() {
		SqlClient ormClient = getClient(truelyDatasource);
		// 使用native sql
		boolean isNativeSql = nativeSql != null && !"".equals(nativeSql.trim());
		if (isNativeSql) {
			Tuple t = SqlParser.parseSql(nativeSql, params, null);
			String truelyNativeSql = t.getObject(0);
			Object[] truelyParams = t.getObject(1);
			return ormClient.queryList(truelyNativeSql, truelyParams, truelyReturnType);
		}
		return ormClient.queryList(new ClasspathSqlResource(sql), params, truelyReturnType);
	}
}