package cn.sylinx.horm.proxy.invoker;

import java.util.Map;

/**
 * 返回分页抽象
 * 
 * @author han
 *
 */
public abstract class AbstractPageCommandInvoker extends AbstractQueryListCommandInvoker {

	protected Integer pageNumber;
	protected Integer pageSize;

	public AbstractPageCommandInvoker(String truelyDatasource, String sql, Map<String, Object> params,
			Integer pageNumber, Integer pageSize, Class<?> truelyReturnType) {
		super(truelyDatasource, sql, params, truelyReturnType);
		this.pageNumber = pageNumber;
		this.pageSize = pageSize;
		parseDefault();
	}

	private void parseDefault() {
		if (pageNumber == null || pageNumber < 1) {
			pageNumber = 1;
		}
		if (pageSize == null || pageSize < 1) {
			pageSize = 10;
		}
	}

	public Integer getPageNumber() {
		return pageNumber;
	}

	public void setPageNumber(Integer pageNumber) {
		this.pageNumber = pageNumber;
	}

	public Integer getPageSize() {
		return pageSize;
	}

	public void setPageSize(Integer pageSize) {
		this.pageSize = pageSize;
	}

}
