package cn.sylinx.horm.proxy.invoker;

import java.util.Map;

import cn.sylinx.horm.core.DynamicClient;
import cn.sylinx.horm.core.SqlClient;
import cn.sylinx.horm.exception.HORMException;

public abstract class AbstractCommandInvoker implements CommandInvoker {

	protected String truelyDatasource;
	protected String sql;
	protected Map<String, Object> params;

	public AbstractCommandInvoker(String truelyDatasource, String sql, Map<String, Object> params) {
		this.truelyDatasource = truelyDatasource;
		this.sql = sql;
		this.params = params;
	}

	public String getTruelyDatasource() {
		return truelyDatasource;
	}

	public void setTruelyDatasource(String truelyDatasource) {
		this.truelyDatasource = truelyDatasource;
	}

	public String getSql() {
		return sql;
	}

	public void setSql(String sql) {
		this.sql = sql;
	}

	public Map<String, Object> getParams() {
		return params;
	}

	public void setParams(Map<String, Object> params) {
		this.params = params;
	}

	@Override
	public void releaseResource() {
		this.truelyDatasource = null;
		this.sql = null;
		this.params = null;
	}

	protected SqlClient getClient(String dataSourceName) {
		SqlClient sqlClientApi = DynamicClient.get(dataSourceName);
		if (sqlClientApi == null) {
			throw new HORMException(dataSourceName + " for client not found");
		}
		return sqlClientApi;
	}
}
