package cn.sylinx.horm.proxy.command;

import java.lang.reflect.Proxy;

public class CommandProxyFactory<T> {
	private final Class<T> commandInterface;
	private T proxyInstance = null;

	public CommandProxyFactory(Class<T> commandInterface) {
		this.commandInterface = commandInterface;
	}

	@SuppressWarnings("unchecked")
	protected T newInstance(CommandProxy<T> commandProxy) {
		if (proxyInstance == null) {
			proxyInstance = (T) Proxy.newProxyInstance(commandInterface.getClassLoader(),
					new Class[] { commandInterface }, commandProxy);
		}
		return proxyInstance;
	}
}