package cn.sylinx.horm.proxy.annotation;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * 
 * @author han
 *
 */
@Documented
@Inherited
@Retention(RUNTIME)
@Target({ METHOD })
public @interface Resource {

	/**
	 * 数据源
	 * 
	 * @return
	 */
	String datasource() default "";

	/**
	 * sql资源
	 * 
	 * @return
	 */
	String sql() default "";

	/**
	 * native sql
	 * 
	 * @return
	 */
	String nativeSql() default "";

	/**
	 * 资源类型，默认查询
	 * 
	 * @return
	 */
	ResourceType resourceType() default ResourceType.QUERY;
}
