package cn.sylinx.horm.exception;

/**
 * 执行运行时异常
 * 
 * @author han
 *
 */
public class HORMException extends RuntimeException implements ErrorCodeRecordable {

	private int code = 500;

	public HORMException() {
		super();
	}

	public HORMException(String message) {
		this(500, message);
	}

	public HORMException(int code, String message) {
		super(message);
		this.code = code;
	}

	public HORMException(String message, Throwable cause) {
		this(500, message, cause);
	}

	public HORMException(int code, String message, Throwable cause) {
		super(message, cause);
		this.code = code;
	}

	public HORMException(Throwable cause) {
		super(cause);
	}

	public int getCode() {
		return code;
	}

	public void setCode(int code) {
		this.code = code;
	}
}
