package cn.sylinx.horm.dialect.fs.builder;

import java.util.HashMap;
import java.util.Map;

import cn.sylinx.horm.dialect.DbType;

public class FSBuilderFactory {

	private final Map<DbType, FSBuilder> registers = new HashMap<DbType, FSBuilder>();

	private static final FSBuilderFactory instance = new FSBuilderFactory();

	private final FSBuilder defaultFluentSqlCreator = new DefaultFSBuilder();

	public static FSBuilderFactory get() {
		return instance;
	}

	private FSBuilderFactory() {
		registerDefault();
	}

	/**
	 * 注册 FSBuilder
	 */
	private void registerDefault() {

		register(DbType.MYSQL, new MySqlFSBuilder());
		register(DbType.ORACLE, new OracleFSBuilder());
		register(DbType.SQLSERVER, new SqlserverFSBuilder());
	}

	public void register(DbType dbType, FSBuilder sqlBuilder) {
		registers.put(dbType, sqlBuilder);
	}

	public FSBuilder getFSBuilder(DbType dbType) {
		FSBuilder sb = registers.get(dbType);
		if (sb == null) {
			return defaultFluentSqlCreator;
		}
		return sb;
	}
}
