package cn.sylinx.horm.dialect;

import cn.sylinx.horm.dialect.impl.ClickHouseDialect;
import cn.sylinx.horm.dialect.impl.Db2Dialect;
import cn.sylinx.horm.dialect.impl.DerbyDialect;
import cn.sylinx.horm.dialect.impl.H2Dialect;
import cn.sylinx.horm.dialect.impl.MySqlDialect;
import cn.sylinx.horm.dialect.impl.OracleDialect;
import cn.sylinx.horm.dialect.impl.PostgreSQLDialect;
import cn.sylinx.horm.dialect.impl.SqlServerDialect;

public enum DialectFactory {
	;

	public static Dialect createDialect(DbType dbType) {

		switch (dbType) {
		case MYSQL:
			return new MySqlDialect();
		case ORACLE:
			return new OracleDialect();
		case SQLSERVER:
			return new SqlServerDialect();
		case DERBY:
			return new DerbyDialect();
		case POSTGRESQL:
			return new PostgreSQLDialect();
		case DB2:
			return new Db2Dialect();
		case H2:
			return new H2Dialect();
		case CLICKHOUSE:
			return new ClickHouseDialect();
		default:
			return new MySqlDialect();
		}
	}

	public static Dialect createDialect(String dbTypeName) {
		return createDialect(DbType.getDbType(dbTypeName));
	}
}