package cn.sylinx.horm.dialect;

import cn.sylinx.horm.dialect.fs.builder.FSBuilder;
import cn.sylinx.horm.dialect.fs.builder.FSBuilderFactory;
import cn.sylinx.horm.dialect.sql.SqlBuilder;
import cn.sylinx.horm.dialect.sql.SqlBuilderFactory;

public interface Dialect {

	/**
	 * 数据库类型
	 * 
	 * @return
	 */
	DbType getDbType();

	/**
	 * sql 创建器
	 * 
	 * @return
	 */
	default SqlBuilder getSqlBuilder() {
		return SqlBuilderFactory.get().getSqlBuilder(getDbType());
	}

	/**
	 * fs 创建器
	 * 
	 * @return
	 */
	default FSBuilder getFSBuilder() {
		return FSBuilderFactory.get().getFSBuilder(getDbType());
	}
}
