package cn.sylinx.horm.core.datasource;

import java.sql.Connection;
import java.sql.SQLException;

/**
 * 数据源方式提供connection
 * 
 * @author johnhan
 *
 */
public class DataSourceConnectionProvicer implements ConnectionProvider {
	
	private NamedDataSource namedDataSource;

	public DataSourceConnectionProvicer() {
	}

	public DataSourceConnectionProvicer(NamedDataSource namedDataSource) {
		this.namedDataSource = namedDataSource;
	}

	public NamedDataSource getNamedDataSource() {
		return namedDataSource;
	}

	public void setNamedDataSource(NamedDataSource namedDataSource) {
		this.namedDataSource = namedDataSource;
	}

	@Override
	public Connection getConnection() throws SQLException {
		return namedDataSource.getConnection();
	}

	@Override
	public void releaseConnection(Connection conn) throws SQLException {
		if (conn != null && !conn.isClosed()) {
			conn.close();
		}
	}

	protected Connection getConnectionFromDataSource() throws SQLException {
		return namedDataSource.getConnection();
	}

	@Override
	public String getDataSourceName() {
		return namedDataSource.getDataSourceName();
	}
}