package cn.sylinx.horm.core.common;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;

import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.util.StrKit;

/**
 * 记录对象
 * 
 * @author han
 *
 */
public class Record implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 8681646517823266152L;

	/**
	 * 结果记录
	 */
	private HashMap<String, Object> result = new HashMap<String, Object>();

	private HashMap<Integer, String> indexMap = new HashMap<Integer, String>();

	/**
	 * 存放值
	 * 
	 * @param column
	 *            列
	 * @param value
	 *            值
	 */
	public void put(String column, Object value) {
		put(column, null, value);
	}

	/**
	 * 存放值
	 * 
	 * @param column
	 * @param index
	 * @param value
	 */
	public void put(String column, Integer index, Object value) {
		String columnAlias = column.toUpperCase();
		if (index != null) {
			indexMap.put(index, columnAlias);
		}
		result.put(columnAlias, value);
	}

	/**
	 * 获取列值
	 * 
	 * @param column
	 *            列
	 * @return Object
	 */
	public Object get(String column) {
		return result.get(column.toUpperCase());
	}

	/**
	 * 通过索引获取值
	 * 
	 * @param index
	 *            从1开始
	 * @return
	 */
	public Object get(int index) {

		if (index < 1) {
			throw new HORMException("索引起始位为1");
		}

		String column = indexMap.get(index);
		if (StrKit.isNotBlank(column)) {
			return get(column);
		}

		throw new HORMException("索引没有找到");
	}

	/**
	 * 获取String
	 * 
	 * @param column
	 *            列
	 * @return String
	 */
	public String getString(String column) {

		Object r = get(column);
		if (r instanceof String) {
			return (String) r;
		}

		if (r != null) {
			return r.toString();
		}

		return null;
	}

	/**
	 * 获取String
	 * 
	 * @param index
	 * @return
	 */
	public String getString(int index) {

		Object r = get(index);
		if (r instanceof String) {
			return (String) r;
		}

		if (r != null) {
			return r.toString();
		}

		return null;
	}

	/**
	 * 获取Integer
	 * 
	 * @param column
	 *            列
	 * @return Integer
	 */
	public Integer getInteger(String column) {

		Object r = get(column);
		if (r instanceof Integer) {
			return (Integer) r;
		}

		if (r != null) {
			return Integer.valueOf(r.toString());
		}

		return null;
	}

	/**
	 * 获取Integer
	 * 
	 * @param index
	 * @return
	 */
	public Integer getInteger(int index) {

		Object r = get(index);
		if (r instanceof Integer) {
			return (Integer) r;
		}

		if (r != null) {
			return Integer.valueOf(r.toString());
		}

		return null;
	}

	/**
	 * 获取Long
	 * 
	 * @param column
	 *            列
	 * @return Long
	 */
	public Long getLong(String column) {

		Object r = get(column);
		if (r instanceof Long) {
			return (Long) r;
		}

		if (r != null) {
			return new Long(r.toString());
		}

		return null;
	}

	/**
	 * 获取Long
	 * 
	 * @param index
	 * @return
	 */
	public Long getLong(int index) {

		Object r = get(index);
		if (r instanceof Long) {
			return (Long) r;
		}

		if (r != null) {
			return new Long(r.toString());
		}

		return null;
	}

	/**
	 * 获取BigInteger
	 * 
	 * @param column
	 *            列
	 * @return BigInteger
	 */
	public BigInteger getBigInteger(String column) {

		Object r = get(column);
		if (r instanceof BigInteger) {
			return (BigInteger) r;
		}

		if (r != null) {
			return new BigInteger(r.toString());
		}

		return null;
	}

	/**
	 * 获取BigInteger
	 * 
	 * @param index
	 * @return
	 */
	public BigInteger getBigInteger(int index) {

		Object r = get(index);
		if (r instanceof BigInteger) {
			return (BigInteger) r;
		}
		if (r != null) {
			return new BigInteger(r.toString());
		}
		return null;
	}

	/**
	 * 获取java.util.Date
	 * 
	 * @param column
	 *            列
	 * @return java.util.Date
	 */
	public java.util.Date getDate(String column) {
		return (java.util.Date) get(column);
	}

	/**
	 * 获取java.util.Date
	 * 
	 * @param index
	 * @return
	 */
	public java.util.Date getDate(int index) {
		return (java.util.Date) get(index);
	}

	/**
	 * 获取java.sql.Time
	 * 
	 * @param column
	 *            列
	 * @return java.sql.Time
	 */
	public java.sql.Time getTime(String column) {
		return (java.sql.Time) get(column);
	}

	/**
	 * 获取java.sql.Time
	 * 
	 * @param index
	 * @return
	 */
	public java.sql.Time getTime(int index) {
		return (java.sql.Time) get(index);
	}

	/**
	 * 获取java.sql.Timestamp
	 * 
	 * @param column
	 *            列
	 * @return java.sql.Timestamp
	 */
	public java.sql.Timestamp getTimestamp(String column) {
		return (java.sql.Timestamp) get(column);
	}

	/**
	 * 获取java.sql.Timestamp
	 * 
	 * @param index
	 * @return
	 */
	public java.sql.Timestamp getTimestamp(int index) {
		return (java.sql.Timestamp) get(index);
	}

	/**
	 * 获取Double
	 * 
	 * @param column
	 *            列
	 * @return Double
	 */
	public Double getDouble(String column) {

		Object r = get(column);
		if (r instanceof Double) {
			return (Double) r;
		}

		if (r != null) {
			return Double.valueOf(r.toString());
		}

		return null;
	}

	/**
	 * 获取Double
	 * 
	 * @param index
	 * @return
	 */
	public Double getDouble(int index) {

		Object r = get(index);
		if (r instanceof Double) {
			return (Double) r;
		}

		if (r != null) {
			return Double.valueOf(r.toString());
		}

		return null;
	}

	/**
	 * 获取Float
	 * 
	 * @param column
	 *            列
	 * @return Float
	 */
	public Float getFloat(String column) {

		Object r = get(column);
		if (r instanceof Float) {
			return (Float) r;
		}

		if (r != null) {
			return Float.valueOf(r.toString());
		}

		return null;
	}

	/**
	 * 获取Float
	 * 
	 * @param index
	 * @return
	 */
	public Float getFloat(int index) {

		Object r = get(index);
		if (r instanceof Float) {
			return (Float) r;
		}

		if (r != null) {
			return Float.valueOf(r.toString());
		}

		return null;
	}

	/**
	 * 获取Boolean
	 * 
	 * @param column
	 *            列
	 * @return Boolean
	 */
	public Boolean getBoolean(String column) {

		Object r = get(column);
		if (r instanceof Boolean) {
			return (Boolean) r;
		}

		if (r != null) {
			return Boolean.valueOf(r.toString());
		}

		return null;
	}

	/**
	 * 获取Boolean
	 * 
	 * @param index
	 * @return
	 */
	public Boolean getBoolean(int index) {

		Object r = get(index);
		if (r instanceof Boolean) {
			return (Boolean) r;
		}

		if (r != null) {
			return Boolean.valueOf(r.toString());
		}

		return null;
	}

	/**
	 * 获取byte
	 * 
	 * @param column
	 * @return
	 */
	public Byte getByte(String column) {

		Object r = get(column);
		if (r instanceof Byte) {
			return (Byte) r;
		}

		if (r != null) {
			return Byte.valueOf(r.toString());
		}

		return null;
	}

	/**
	 * 获取byte
	 * 
	 * @param index
	 * @return
	 */
	public Byte getByte(int index) {

		Object r = get(index);
		if (r instanceof Byte) {
			return (Byte) r;
		}

		if (r != null) {
			return Byte.valueOf(r.toString());
		}

		return null;
	}

	/**
	 * 获取值
	 * 
	 * @param column
	 * @param clz
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public <T> T get(String column, Class<T> clz) {

		Object r = get(column);

		if (clz.isAssignableFrom(r.getClass())) {
			return (T) r;
		}
		return null;
	}

	/**
	 * 获取值
	 * 
	 * @param index
	 * @param clz
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public <T> T get(int index, Class<T> clz) {

		Object r = get(index);
		if (clz.isAssignableFrom(r.getClass())) {
			return (T) r;
		}
		return null;
	}

	/**
	 * 获取java.math.BigDecimal
	 * 
	 * @param column
	 *            列
	 * @return java.math.BigDecimal
	 */
	public java.math.BigDecimal getBigDecimal(String column) {

		Object r = get(column);
		if (r instanceof BigDecimal) {
			return (BigDecimal) r;
		}

		if (r != null) {
			return new BigDecimal(r.toString());
		}

		return null;
	}

	/**
	 * 获取java.math.BigDecimal
	 * 
	 * @param index
	 * @return
	 */
	public java.math.BigDecimal getBigDecimal(int index) {

		Object r = get(index);
		if (r instanceof BigDecimal) {
			return (BigDecimal) r;
		}

		if (r != null) {
			return new BigDecimal(r.toString());
		}

		return null;
	}

	/**
	 * 获取byte[]
	 * 
	 * @param column
	 *            列
	 * @return byte[]
	 */
	public byte[] getBytes(String column) {
		return (byte[]) get(column);
	}

	/**
	 * 获取byte[]
	 * 
	 * @param index
	 * @return
	 */
	public byte[] getBytes(int index) {
		return (byte[]) get(index);
	}

	/**
	 * 获取Number
	 * 
	 * @param column
	 *            列
	 * @return Number
	 */
	public Number getNumber(String column) {
		return (Number) get(column);
	}

	/**
	 * 获取Number
	 * 
	 * @param index
	 * @return
	 */
	public Number getNumber(int index) {
		return (Number) get(index);
	}

	public HashMap<String, Object> getResult() {
		return result;
	}

	public void setResult(HashMap<String, Object> result) {
		this.result = result;
	}

	public HashMap<Integer, String> getIndexMap() {
		return indexMap;
	}

	public void setIndexMap(HashMap<Integer, String> indexMap) {
		this.indexMap = indexMap;
	}

	public void clear() {
		indexMap.clear();
		result.clear();
	}
}
