package cn.sylinx.horm.core.common;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import cn.sylinx.horm.type.TypeHandlerRegistry;
import cn.sylinx.horm.type.handler.TypeHandler;

@SuppressWarnings("unchecked")
public class OrmUtil {

	public static void setParameter(PreparedStatement pst, int index, Object param) throws SQLException {

		TypeHandler<Object> handler = crateTypeHandler(param);
		if (handler != null) {
			handler.setParameter(pst, index, param);
		} else {
			pst.setObject(index, param);
		}
	}

	public static TypeHandler<Object> crateTypeHandler(Object param) {

		if (param == null) {
			return TypeHandlerRegistry.getInstance().getUnknownTypeHandler();
		}

		Class<Object> clz = (Class<Object>) param.getClass();
		return TypeHandlerRegistry.getInstance().getTypeHandler(clz);
	}

	public static <T> T getResult(ResultSet rs, String columnName, Class<T> clz) throws SQLException {

		TypeHandler<T> handler = TypeHandlerRegistry.getInstance().getTypeHandler(clz);
		if (handler != null) {
			return handler.getResult(rs, columnName);
		}

		return (T) rs.getObject(columnName);
	}

	public static <T> T getResult(ResultSet rs, int columnIndex, Class<T> clz) throws SQLException {

		TypeHandler<T> handler = TypeHandlerRegistry.getInstance().getTypeHandler(clz);
		if (handler != null) {
			return handler.getResult(rs, columnIndex);
		}

		return (T) rs.getObject(columnIndex);
	}

	public static <T> T getResult(CallableStatement cs, int columnIndex, Class<T> clz) throws SQLException {

		TypeHandler<T> handler = TypeHandlerRegistry.getInstance().getTypeHandler(clz);
		if (handler != null) {
			return handler.getResult(cs, columnIndex);
		}

		return (T) cs.getObject(columnIndex);
	}
}
