package cn.sylinx.horm.core;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import cn.sylinx.horm.core.common.Callable;
import cn.sylinx.horm.core.common.Page;
import cn.sylinx.horm.core.common.Record;
import cn.sylinx.horm.dialect.Dialect;
import cn.sylinx.horm.resource.ClasspathSqlResource;

public interface SqlClient extends FluentSqlClient {
	
	// for sql client begin
	public SqlClient getClient(String dsName);

	public String getDataSourceName();

	public int insert(final String insertSql, final Object... params) throws SQLException;

	public int delete(final String deleteSql, final Object... params) throws SQLException;

	public int update(final String updateSql, final Object... params) throws SQLException;

	public Object insertForRetrieval(final String insertSql, final Object... params) throws SQLException;

	public boolean execute(final String exeSql, final Object... params) throws SQLException;

	public List<Object[]> query(final String querySql, final Object... params) throws SQLException;

	public List<Object> queryForSingleColumn(final String querySql, final Object... params) throws SQLException;

	public <T> T call(Callable<T> callable) throws SQLException;
	// for sql client end
	
	// for orm client begin
	public Dialect getDialect();

	public <T> Serializable save(T t);

	public <T> int delete(T t);

	public <T> int update(T t);

	public int update(ClasspathSqlResource sqlResource, Map<String, Object> params);

	public boolean execute(ClasspathSqlResource sqlResource, Map<String, Object> params);

	public <T> T get(Serializable id, Class<T> modelClass);

	public Page<Record> queryPage(String sql, int pageNumber, int pageSize, Object[] params);

	public Page<Record> queryPage(ClasspathSqlResource sqlResource, int pageNumber, int pageSize,
			Map<String, Object> params);

	public <T> Page<T> queryPage(String sql, int pageNumber, int pageSize, Object[] params, Class<T> clz);

	public <T> Page<T> queryPage(ClasspathSqlResource sqlResource, int pageNumber, int pageSize,
			Map<String, Object> params, Class<T> clz);

	public <R> Page<R> queryPageForSingleColumn(String sql, int pageNumber, int pageSize, Object[] params,
			Class<R> clz);

	public Record queryRecord(String querySql, Object... params);

	public List<Record> queryRecords(String querySql, Object... params);

	public <T> List<T> queryList(Class<T> modelClass);

	public <T> T queryFirst(final String querySql, final Object[] params, Class<T> modelClass);
	
	public <T> List<T> queryList(final String querySql, final Object[] params, Class<T> modelClass);

	public <T> T queryFirstForSingleColumn(ClasspathSqlResource sqlResource, Map<String, Object> params,
			Class<T> modelClass);

	public <T> List<T> queryListForSingleColumn(ClasspathSqlResource sqlResource, Map<String, Object> params,
			Class<T> modelClass);

	public <T> T queryFirstForSingleColumn(final String querySql, final Object[] params, Class<T> modelClass);

	public <T> List<T> queryListForSingleColumn(final String querySql, final Object[] params, Class<T> modelClass);

	public <T> T queryFirst(ClasspathSqlResource sqlResource, Map<String, Object> params, Class<T> modelClass);

	public <T> List<T> queryList(ClasspathSqlResource sqlResource, Map<String, Object> params, Class<T> modelClass);

	public Record queryRecord(ClasspathSqlResource sqlResource, Map<String, Object> params);

	public List<Record> queryRecords(ClasspathSqlResource sqlResource, Map<String, Object> params);
	// for orm client end
}