package cn.sylinx.horm.core;

import java.util.HashMap;
import java.util.Map;

/**
 * 保存不同数据源客户端操作
 * 
 * @author johnhan
 *
 */
public enum DynamicClient {
	;
	public static final String DEFAULT_DS_NAME = "_DEFAULT_DS_NAME_FOR_HORM_";
	private static Map<String, SqlClient> clientMaps = new HashMap<>();

	// 获取默认SqlClient
	public static SqlClient get() {
		return get(DEFAULT_DS_NAME);
	}

	public static SqlClient get(String dsName) {
		return clientMaps.get(dsName);
	}

	public static void register(SqlClient sqlClient) {
		clientMaps.put(sqlClient.getDataSourceName(), sqlClient);
	}
}