package cn.sylinx.horm.config;

import java.util.Arrays;
import java.util.List;
import cn.sylinx.horm.resource.ClasspathSqlResourceManager;
import cn.sylinx.horm.util.ClasspathResourceScanner;
import cn.sylinx.horm.util.GLog;
import cn.sylinx.horm.util.StrKit;

class SqlResourceLoader {
	private OrmConfig ormConfig;

	SqlResourceLoader(OrmConfig ormConfig) {
		this.ormConfig = ormConfig;
	}

	public void load() {
		String[] pathArray = ormConfig.getSqlPath().split(",");
		List<String> resourcePaths = Arrays.asList(pathArray);
		if (resourcePaths == null) {
			return;
		}
		resourcePaths.stream().filter(StrKit::isNotBlank).forEach(item -> {
			boolean bl = load(item);
			if (bl) {
				GLog.info("resourcesPath:{} load ok..", item);
			} else {
				GLog.info("resourcesPath:{} load error..", item);
			}
		});
	}

	private boolean load(String resourcesPath) {
		ClasspathResourceScanner crs = new ClasspathResourceScanner(resourcesPath, ".sql");
		List<String> rlist = null;
		try {
			rlist = crs.getResourceNameList();
		} catch (Exception e) {
			GLog.error("resource not found ", e);
			return false;
		}
		if (rlist == null || rlist.isEmpty()) {
			return false;
		}
		for (String r : rlist) {
			ClasspathSqlResourceManager.loadAndGet(r);
			GLog.info("resource:{} loaded ", r);
		}
		return true;
	}
}