package cn.sylinx.horm.config;

import java.sql.Connection;

import cn.sylinx.horm.cache.impl.GuavaCacheConfig;
import cn.sylinx.horm.dialect.DbType;
import cn.sylinx.horm.model.strategy.Strategy;

/**
 * 配置相关
 * 
 * @author johnhan
 *
 */
public class OrmConfig implements Cloneable {
	// 是否启用调试
	private boolean debug = false;
	// 是否启用缓存
	private boolean cache = false;
	// 数据库类型，使用单数据源时有效
	private String dbtype = DbType.MYSQL.getValue();
	// guava cache 配置
	private GuavaCacheConfig guavaCacheConfig;
	// sql资源文件
	private String sqlPath;
	// 乐观锁是否启用
	private boolean optimisticLockEnable = false;
	// command 扫描包
	private String commandScanPackage;
	// 模型映射策略，underline ｜ attr （下划线、属性一致）
	private String modelMapStrategy = Strategy.STRATEGY_UNDERLINE;
	// jdbc 事务隔离级别，普通java项目中可设置
	private int transactionIsolation = Connection.TRANSACTION_READ_COMMITTED;
	// 数据源相关
	private DataSourceConfig datasource;

	public boolean isDebug() {
		return debug;
	}

	public void setDebug(boolean debug) {
		this.debug = debug;
	}

	public boolean isCache() {
		return cache;
	}

	public void setCache(boolean cache) {
		this.cache = cache;
	}

	public String getDbtype() {
		return dbtype;
	}

	public void setDbtype(String dbtype) {
		this.dbtype = dbtype;
	}

	public GuavaCacheConfig getGuavaCacheConfig() {
		return guavaCacheConfig;
	}

	public void setGuavaCacheConfig(GuavaCacheConfig guavaCacheConfig) {
		this.guavaCacheConfig = guavaCacheConfig;
	}

	public String getSqlPath() {
		return sqlPath;
	}

	public void setSqlPath(String sqlPath) {
		this.sqlPath = sqlPath;
	}

	public boolean isOptimisticLockEnable() {
		return optimisticLockEnable;
	}

	public void setOptimisticLockEnable(boolean optimisticLockEnable) {
		this.optimisticLockEnable = optimisticLockEnable;
	}

	public String getCommandScanPackage() {
		return commandScanPackage;
	}

	public void setCommandScanPackage(String commandScanPackage) {
		this.commandScanPackage = commandScanPackage;
	}

	public DataSourceConfig getDatasource() {
		return datasource;
	}

	public void setDatasource(DataSourceConfig datasource) {
		this.datasource = datasource;
	}

	public String getModelMapStrategy() {
		return modelMapStrategy;
	}

	public void setModelMapStrategy(String modelMapStrategy) {
		this.modelMapStrategy = modelMapStrategy;
	}

	public int getTransactionIsolation() {
		return transactionIsolation;
	}

	public void setTransactionIsolation(int transactionIsolation) {
		this.transactionIsolation = transactionIsolation;
	}

	@Override
	protected Object clone() throws CloneNotSupportedException {
		OrmConfig clone = (OrmConfig) super.clone();
		clone.setGuavaCacheConfig(guavaCacheConfig == null ? null : (GuavaCacheConfig) guavaCacheConfig.clone());
		return clone;
	}
}