package cn.sylinx.horm.config;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import cn.sylinx.horm.proxy.annotation.Command;
import cn.sylinx.horm.proxy.command.CommandRegistry;
import cn.sylinx.horm.util.ClasspathResourceScanner;
import cn.sylinx.horm.util.GLog;
import cn.sylinx.horm.util.StrKit;

class CommandLoader {

	private OrmConfig ormConfig;

	CommandLoader(OrmConfig ormConfig) {
		this.ormConfig = ormConfig;
	}
	
	public void load() {

		// Command 扫描包，如果为空，则全项目扫描
		String commandScanPackage = ormConfig.getCommandScanPackage();
		if (StrKit.isBlank(commandScanPackage)) {
			GLog.warn("hbatis.command.scanpackage没有配置，这将导致花费更多时间扫描整个项目");
		}
		GLog.info("扫描包:{}, 寻找@Command对象", StrKit.isBlank(commandScanPackage) ? "整个项目" : commandScanPackage);

		Set<String> clzSets = new HashSet<>(16);
		// 扫码所有class，寻找Command注解
		ClasspathResourceScanner cp = new ClasspathResourceScanner(commandScanPackage, ".class", true);
		List<String> rList = null;
		try {
			rList = cp.getResourceNameList();
		} catch (Exception e) {
			GLog.error("scan error", e);
		}

		if (rList == null) {
			rList = new ArrayList<String>();
		}

		for (String rs : rList) {
			if (commandScanPackage == "") {
				rs = rs.substring(1);
			}
			String pt1 = rs.replaceAll("/", "\\.");
			int index = pt1.lastIndexOf(".class");
			pt1 = pt1.substring(0, index);
			clzSets.add(pt1);
		}

		if (clzSets == null || clzSets.isEmpty()) {
			return;
		}

		for (String clzStr : clzSets) {
			try {
				Class<?> clz = Class.forName(clzStr);
				Command command = clz.getDeclaredAnnotation(Command.class);

				if (clz.isInterface() && clz.getSuperclass() == null && command != null) {
					GLog.info("注册Command对象:{}", clz.getName());
					CommandRegistry.INSTANCE.addCommond(clz);
				}

			} catch (Throwable e) {
				// do nothing
				GLog.error("register error", e);
			}
		}

		GLog.info("寻找@Command对象完毕，总计:{}", CommandRegistry.INSTANCE.getCommands().size());

	}
}
