/*
 * Decompiled with CFR 0.152.
 */
package cn.sx.yys.commons.utils.ip;

import cn.sx.yys.commons.utils.http.HttpUtil;
import cn.sx.yys.commons.utils.ip.IpUtil;
import cn.sx.yys.commons.utils.string.StringUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressUtil {
    private static final Logger log = LoggerFactory.getLogger(AddressUtil.class);
    public static final String IP_URL = "http://whois.pconline.com.cn/ipJson.jsp";
    public static final String UNKNOWN = "XX XX";

    public static String getRealAddressByIP(String ip) {
        String address = UNKNOWN;
        if (IpUtil.internalIp(ip)) {
            return "\u5185\u7f51IP";
        }
        try {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("ip", ip);
            param.put("json", "true");
            String rspStr = HttpUtil.sendGet(IP_URL, param, "utf8", "GBK", new String[0]);
            if (StringUtil.isEmpty(rspStr)) {
                log.error("\u83b7\u53d6\u5730\u7406\u4f4d\u7f6e\u5f02\u5e38 {}", (Object)ip);
                return UNKNOWN;
            }
            JSONObject obj = JSONObject.parseObject((String)rspStr);
            String region = obj.getString("pro");
            String city = obj.getString("city");
            return String.format("%s %s", region, city);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5730\u7406\u4f4d\u7f6e\u5f02\u5e38 {}", (Object)ip);
            return address;
        }
    }
}

