/*
 * Decompiled with CFR 0.152.
 */
package cn.sx.yys.commons.utils.im;

import cn.sx.yys.commons.entity.im.OpenfireModel;
import javax.ws.rs.core.Response;
import org.igniterealtime.restclient.RestApiClient;
import org.igniterealtime.restclient.entity.AuthenticationToken;
import org.igniterealtime.restclient.entity.UserEntities;
import org.igniterealtime.restclient.entity.UserEntity;

public class OpenfireUtil {
    public static RestApiClient createClient(OpenfireModel model) {
        AuthenticationToken authenticationToken = new AuthenticationToken(model.getSharedSecretKey());
        return new RestApiClient(model.getUrl(), model.getPort().intValue(), authenticationToken);
    }

    public static boolean createUser(RestApiClient restApiClient, String username, String name, String email, String password) {
        boolean createSuccess = false;
        try {
            UserEntity userEntity = new UserEntity(username, name, email, password);
            Response response = restApiClient.createUser(userEntity);
            if (response.getStatus() == 201) {
                createSuccess = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return createSuccess;
    }

    public static boolean udpateByUserName(RestApiClient restApiClient, String username, String name, String email, String password) {
        boolean updateSuccess = false;
        try {
            UserEntity userEntity = OpenfireUtil.getUserByUserName(restApiClient, username);
            if (userEntity != null) {
                userEntity.setName(name);
                userEntity.setEmail(email);
                userEntity.setPassword(password);
                Response response = restApiClient.updateUser(userEntity);
                if (response.getStatus() == 200) {
                    updateSuccess = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return updateSuccess;
    }

    public static UserEntity getUserByUserName(RestApiClient restApiClient, String userName) {
        UserEntity userEntity = null;
        try {
            userEntity = restApiClient.getUser(userName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return userEntity;
    }

    public static UserEntities getUsers(RestApiClient restApiClient) {
        UserEntities userEntities = null;
        try {
            userEntities = restApiClient.getUsers();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return userEntities;
    }

    public static boolean deleteByUserName(RestApiClient restApiClient, String userName) {
        boolean deleteSuccess = false;
        try {
            Response response;
            UserEntity userEntity = OpenfireUtil.getUserByUserName(restApiClient, userName);
            if (userEntity != null && (response = restApiClient.deleteUser(userName)).getStatus() == 200) {
                deleteSuccess = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return deleteSuccess;
    }
}

