package cn.sx.yys.commons.utils.oss;

import cn.sx.yys.commons.entity.oss.AliOssModel;
import cn.sx.yys.commons.utils.string.StringUtil;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.PutObjectResult;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.io.InputStream;

/**
 * 阿里云oss存储工具类
 *
 * @author YuanShuai[apeblog@163.com]
 */
public class AliOssUtil {

    /**
     * 上传文件到阿里云oss
     * @param model 阿里云oss配置模型
     * @param file 要上传的文件
     * @return 上传后的地址
     */
    public static String uploadFile(AliOssModel model, MultipartFile file) {
        String res = "";
        OSS oss = createConnection(model);
        InputStream inputStream = null;
        try {
            //获取文件流
            inputStream = file.getInputStream();
            //获取上传的文件名
            String fileName = StringUtil.fileNameAddTimestamp(file.getOriginalFilename());
            oss.putObject(model.getBucketName(), fileName, inputStream);
            cleanConnection(oss);
            res = "https://" + model.getBucketName() + "." + model.getEndpoint() + "/" + fileName;
        } catch (IOException e) {
            e.printStackTrace();
            res = e.getMessage();
        } finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    /**
     * 创建oss连接
     *
     * @param model oss配置模型
     * @return OSS
     */
    private static OSS createConnection(AliOssModel model) {
        return new OSSClientBuilder().build(model.getEndpoint(), model.getKeyId(), model.getKeySecret());
    }

    /**
     * 关闭oss连接
     *
     * @param oss
     */
    private static void cleanConnection(OSS oss) {
        oss.shutdown();
    }

}
