package cn.sx.yys.commons.utils.mail;

import cn.sx.yys.commons.entity.mail.EmailModel;
import cn.sx.yys.commons.entity.mail.ToModel;
import lombok.extern.slf4j.Slf4j;

import javax.mail.*;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import java.util.Properties;

/**
 * 邮件发送工具类
 *
 * @author YuanShuai[apeblog@163.com]
 */
@Slf4j
public class SendMailUtil {
    /**
     * 发送普通邮件
     *
     * @param email 发送人
     * @param to 接收人及发送信息
     * @return true or false
     */
    public static boolean sendMail(EmailModel email, ToModel to) {
        log.info("发送普通邮件");
        log.info("发送方: {}",email.getUsername());
        log.info("接收方: {}",to.getEmail());
        log.info("邮件标题: {}",to.getTitle());
        log.info("邮件内容: {}",to.getContent());
        try {
            final Properties props = new Properties();
            props.put("mail.smtp.auth", "true");
            props.put("mail.smtp.host", email.getHost());
            props.put("mail.user", email.getUsername());
            props.put("mail.password", email.getPassword());

            Authenticator authenticator = new Authenticator() {
                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    String userName = props.getProperty("mail.user");
                    String password = props.getProperty("mail.password");
                    return new PasswordAuthentication(userName, password);
                }
            };
            Session mailSession = Session.getInstance(props, authenticator);
            MimeMessage message = new MimeMessage(mailSession);
            String username = props.getProperty("mail.user");
            InternetAddress form = new InternetAddress(username);
            message.setFrom(form);

            InternetAddress toAddress = new InternetAddress(to.getEmail());
            message.setRecipient(Message.RecipientType.TO, toAddress);

            message.setSubject(to.getTitle());

            message.setContent(to.getContent(), "text/html;charset=UTF-8");
            Transport.send(message);

            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void main(String[] args) {
        EmailModel email = new EmailModel("smtp.163.com","apeblog@163.com","WIBXNBDDFSBKURFX");
        ToModel to = new ToModel("1603194187@qq.com");
        to.setTitle("测试邮件发送");
        to.setContent("这是一份测试邮件");
        long beginTime = System.currentTimeMillis();
        boolean b = SendMailUtil.sendMail(email, to);
        long endTime = System.currentTimeMillis();
        log.info("发送{}",b?"成功":"失败");
        log.info("发送所用时间: {}",endTime-beginTime);
    }
}
