package cn.sx.yys.commons.utils.im;

import cn.sx.yys.commons.entity.im.OpenfireModel;
import org.igniterealtime.restclient.RestApiClient;
import org.igniterealtime.restclient.entity.AuthenticationToken;
import org.igniterealtime.restclient.entity.UserEntities;
import org.igniterealtime.restclient.entity.UserEntity;

import javax.ws.rs.core.Response;

/**
 * openfire操作工具类
 *
 * @author YuanShuai[apeblog@163.com]
 */
public class OpenfireUtil {

    /**
     * 创建客户端连接信息
     *
     * @param model openfire连接信息模型
     * @return 连接信息
     */
    public static RestApiClient createClient(OpenfireModel model){
        AuthenticationToken authenticationToken = new AuthenticationToken(model.getSharedSecretKey());
        // 创建客户端
        return new RestApiClient(model.getUrl(), model.getPort(), authenticationToken);
    }

    /**
     * 创建用户
     *
     * @param restApiClient 连接信息
     * @param username 用户名
     * @param name 昵称
     * @param email 邮箱
     * @param password 密码
     * @return 是否成功
     */
    public static boolean createUser(RestApiClient restApiClient, String username, String name, String email, String password) {
        boolean createSuccess = false;
        try {
            UserEntity userEntity = new UserEntity(username, name, email, password);
            Response response = restApiClient.createUser(userEntity);
            if(response.getStatus() == 201){
                createSuccess = true;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return createSuccess;
    }

    /**
     * 修改用户信息
     *
     * @param restApiClient 连接信息
     * @param username 用户名
     * @param name 昵称
     * @param email 邮箱
     * @param password 密码
     * @return 是否成功
     */
    public static boolean udpateByUserName(RestApiClient restApiClient,String username, String name, String email, String password) {
        boolean updateSuccess = false;
        try {
            UserEntity userEntity = getUserByUserName(restApiClient, username);
            if(userEntity != null) {
                userEntity.setName(name);
                userEntity.setEmail(email);
                userEntity.setPassword(password);
                Response response = restApiClient.updateUser(userEntity);
                if(response.getStatus() == 200){
                    updateSuccess = true;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return updateSuccess;
    }

    /**
     * 根据用户名称获取用户
     *
     * @param restApiClient 连接信息
     * @param userName 用户名
     * @return 用户信息实体
     */
    public static UserEntity getUserByUserName(RestApiClient restApiClient, String userName) {
        UserEntity userEntity = null;
        try {
            userEntity = restApiClient.getUser(userName);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return userEntity;
    }

    /**
     * 获取所有用户
     *
     * @param restApiClient 连接信息
     * @return 用户信息列表实体
     */
    public static UserEntities getUsers(RestApiClient restApiClient) {
        UserEntities userEntities = null;
        try {
            userEntities = restApiClient.getUsers();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return userEntities;
    }

    /**
     * 根据用户名称删除用户
     *
     * @param restApiClient 连接信息
     * @param userName 用户名
     * @return 是否成功
     */
    public static boolean deleteByUserName(RestApiClient restApiClient,String userName) {
        boolean deleteSuccess = false;
        try {
            UserEntity userEntity = getUserByUserName(restApiClient, userName);
            if(userEntity != null) {
                Response response = restApiClient.deleteUser(userName);
                if(response.getStatus() == 200){
                    deleteSuccess = true;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return deleteSuccess;
    }

}
