/*
 * Decompiled with CFR 0.152.
 */
package cn.sx.yys.commons.utils.servlet;

import cn.sx.yys.commons.utils.string.StringUtil;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ServletUtil {
    public static ServletRequestAttributes getRequestAttributes() {
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        return (ServletRequestAttributes)attributes;
    }

    public static HttpServletRequest getRequest() {
        return ServletUtil.getRequestAttributes().getRequest();
    }

    public static HttpServletResponse getResponse() {
        return ServletUtil.getRequestAttributes().getResponse();
    }

    public static HttpSession getSession() {
        return ServletUtil.getRequest().getSession();
    }

    public static String getParameter(String name) {
        return ServletUtil.getRequest().getParameter(name);
    }

    public static Integer getParameterToInt(String name) {
        return Integer.parseInt(ServletUtil.getRequest().getParameter(name));
    }

    public static String renderString(HttpServletResponse response, String string) {
        try {
            response.setStatus(200);
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            response.getWriter().print(string);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        String accept = request.getHeader("accept");
        if (accept != null && accept.indexOf("application/json") != -1) {
            return true;
        }
        String xRequestedWith = request.getHeader("X-Requested-With");
        if (xRequestedWith != null && xRequestedWith.indexOf("XMLHttpRequest") != -1) {
            return true;
        }
        String uri = request.getRequestURI();
        if (StringUtil.inStringIgnoreCase(uri, ".json", ".xml")) {
            return true;
        }
        String ajax = request.getParameter("__ajax");
        return StringUtil.inStringIgnoreCase(ajax, "json", "xml");
    }
}

