/*
 * Decompiled with CFR 0.152.
 */
package cn.sx.yys.commons.utils.oss;

import cn.sx.yys.commons.entity.oss.AliOssModel;
import cn.sx.yys.commons.utils.string.StringUtil;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.web.multipart.MultipartFile;

public class AliOssUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uploadFile(AliOssModel model, MultipartFile file) {
        String res = "";
        OSS oss = AliOssUtil.createConnection(model);
        InputStream inputStream = null;
        try {
            inputStream = file.getInputStream();
            String fileName = StringUtil.fileNameAddTimestamp(file.getOriginalFilename());
            oss.putObject(model.getBucketName(), fileName, inputStream);
            AliOssUtil.cleanConnection(oss);
            res = "https://" + model.getBucketName() + "." + model.getEndpoint() + "/" + fileName;
        }
        catch (IOException e) {
            e.printStackTrace();
            res = e.getMessage();
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    private static OSS createConnection(AliOssModel model) {
        return new OSSClientBuilder().build(model.getEndpoint(), model.getKeyId(), model.getKeySecret());
    }

    private static void cleanConnection(OSS oss) {
        oss.shutdown();
    }
}

