/*
 * Decompiled with CFR 0.152.
 */
package cn.sx.yys.commons.utils.mail;

import cn.sx.yys.commons.entity.mail.EmailModel;
import cn.sx.yys.commons.entity.mail.ToModel;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMailUtil {
    private static final Logger log = LoggerFactory.getLogger(SendMailUtil.class);

    public static boolean sendMail(EmailModel email, ToModel to) {
        log.info("\u53d1\u9001\u666e\u901a\u90ae\u4ef6");
        log.info("\u53d1\u9001\u65b9: {}", (Object)email.getUsername());
        log.info("\u63a5\u6536\u65b9: {}", (Object)to.getEmail());
        log.info("\u90ae\u4ef6\u6807\u9898: {}", (Object)to.getTitle());
        log.info("\u90ae\u4ef6\u5185\u5bb9: {}", (Object)to.getContent());
        try {
            final Properties props = new Properties();
            props.put("mail.smtp.auth", "true");
            props.put("mail.smtp.host", email.getHost());
            props.put("mail.user", email.getUsername());
            props.put("mail.password", email.getPassword());
            Authenticator authenticator = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    String userName = props.getProperty("mail.user");
                    String password = props.getProperty("mail.password");
                    return new PasswordAuthentication(userName, password);
                }
            };
            Session mailSession = Session.getInstance((Properties)props, (Authenticator)authenticator);
            MimeMessage message = new MimeMessage(mailSession);
            String username = props.getProperty("mail.user");
            InternetAddress form = new InternetAddress(username);
            message.setFrom((Address)form);
            InternetAddress toAddress = new InternetAddress(to.getEmail());
            message.setRecipient(Message.RecipientType.TO, (Address)toAddress);
            message.setSubject(to.getTitle());
            message.setContent((Object)to.getContent(), "text/html;charset=UTF-8");
            Transport.send((Message)message);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void main(String[] args) {
        EmailModel email = new EmailModel("smtp.163.com", "apeblog@163.com", "WIBXNBDDFSBKURFX");
        ToModel to = new ToModel("1603194187@qq.com");
        to.setTitle("\u6d4b\u8bd5\u90ae\u4ef6\u53d1\u9001");
        to.setContent("\u8fd9\u662f\u4e00\u4efd\u6d4b\u8bd5\u90ae\u4ef6");
        long beginTime = System.currentTimeMillis();
        boolean b = SendMailUtil.sendMail(email, to);
        long endTime = System.currentTimeMillis();
        log.info("\u53d1\u9001{}", (Object)(b ? "\u6210\u529f" : "\u5931\u8d25"));
        log.info("\u53d1\u9001\u6240\u7528\u65f6\u95f4: {}", (Object)(endTime - beginTime));
    }
}

