/*
 * Decompiled with CFR 0.152.
 */
package cn.sx.yys.commons.utils.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class JsonUtil {
    public static ObjectMapper MAPPER = new ObjectMapper();

    public static String toJSON(Object obj) {
        String json = null;
        try {
            json = MAPPER.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return json;
    }

    public static <T> T parseObject(String json, Class<T> type) {
        Object obj = null;
        try {
            obj = MAPPER.readValue(json, type);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (T)obj;
    }

    public static <T> List<T> parseList(String json, Class<T> type) {
        JavaType listType = MAPPER.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{type});
        Object obj = null;
        try {
            obj = MAPPER.readValue(json, listType);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (List)obj;
    }
}

