/*
 * Decompiled with CFR 0.152.
 */
package cn.sx.yys.commons.utils.date;

import java.lang.management.ManagementFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.time.DateFormatUtils;

public class DateUtil {
    public static String YYYY = "yyyy";
    public static String YYYY_MM = "yyyy-MM";
    public static String YYYY_MM_DD = "yyyy-MM-dd";
    public static String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    private static String[] parsePatterns = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM", "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy.MM"};

    public static Date getNowDate() {
        return new Date();
    }

    public static String getDate(String format) {
        if (format == null) {
            format = YYYY_MM_DD;
        }
        return DateUtil.parseDateToStr(format, DateUtil.getNowDate());
    }

    public static final String parseDateToStr(String format, Date date) {
        return new SimpleDateFormat(format).format(date);
    }

    public static final Date parseStrToDate(String format, String ts) {
        try {
            return new SimpleDateFormat(format).parse(ts);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Date getServerStartDate() {
        long time = ManagementFactory.getRuntimeMXBean().getStartTime();
        return new Date(time);
    }

    public static String getDatePoor(Date endDate, Date nowDate) {
        long nd = 86400000L;
        long nh = 3600000L;
        long nm = 60000L;
        long diff = endDate.getTime() - nowDate.getTime();
        long day = diff / nd;
        long hour = diff % nd / nh;
        long min = diff % nd % nh / nm;
        return day + "\u5929" + hour + "\u5c0f\u65f6" + min + "\u5206\u949f";
    }

    public static Date getDateTime(Date date, String time) {
        String format = DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd");
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(format + " " + time);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date getDateAfter(Date d, int day) {
        Calendar now = Calendar.getInstance();
        now.setTime(d);
        now.set(5, now.get(5) + day);
        return now.getTime();
    }

    public static Date isNowDateBefore(String time) {
        Date nowDate = DateUtil.getNowDate();
        String format = DateFormatUtils.format((Date)nowDate, (String)"yyyy-MM-dd");
        format = format + " " + time;
        Date date = null;
        try {
            date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(format);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (nowDate.getTime() < date.getTime()) {
            return date;
        }
        Date dateAfter = DateUtil.getDateAfter(nowDate, 1);
        return DateUtil.getDateTime(dateAfter, time);
    }

    public static Date getNowDateBefore(Date nowDate, String time) {
        String format = DateFormatUtils.format((Date)nowDate, (String)"yyyy-MM-dd");
        format = format + " " + time;
        Date date = null;
        try {
            date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(format);
            if (nowDate.getTime() < date.getTime()) {
                return date;
            }
            Date dateAfter = DateUtil.getDateAfter(nowDate, 1);
            return DateUtil.getDateTime(dateAfter, time);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String setDateTimeZone(Date date, String timeZone) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        format.setTimeZone(TimeZone.getTimeZone(timeZone));
        return format.format(date);
    }
}

