package cn.sx.yys.commons.entity.mail;

import lombok.Data;
import lombok.ToString;

/**
 * 邮件发送者实体
 *
 * @author YuanShuai[apeblog@163.com]
 */
@Data
@ToString
public class EmailModel {

    /**
     * 邮件服务器
     */
    private String host;

    /**
     * 邮箱号
     */
    private String username;

    /**
     * 密钥
     */
    private String password;

    /**
     * 发送端口
     */
    private Integer port = 465;

    /**
     * 发送协议
     */
    private String protocol = "smtp";

    /**
     * 默认编码格式
     */
    private String defaultEncoding = "utf-8";

    public EmailModel(String host, String username, String password) {
        this.host = host;
        this.username = username;
        this.password = password;
    }
}
