/*
 * Decompiled with CFR 0.152.
 */
package cn.svipbot.gocq.utils;

import cn.svipbot.gocq.enums.EGiftType;
import cn.svipbot.gocq.enums.EImageEffect;
import cn.svipbot.gocq.enums.EImageSubType;
import cn.svipbot.gocq.enums.EImageType;
import java.util.ArrayList;

public class CqMsg
extends ArrayList<String> {
    public String unescape(String str) {
        return str.replace("&#44;", ",").replace("&#91;", "[").replace("&#93;", "]").replace("&amp;", "&");
    }

    private String escape(String str) {
        return str.replace("&", "&amp;").replace(",", "&#44;").replace("[", "&#91;").replace("]", "&#93;");
    }

    public CqMsg build() {
        return this;
    }

    public CqMsg text(String text) {
        this.add(text);
        return this;
    }

    public CqMsg face(int id) {
        this.add(String.format("[CQ:face,id=%d]", id));
        return this;
    }

    public CqMsg record(String file, int magic) {
        this.add(String.format("[CQ:record,file=%s,magic=%d]", this.escape(file), magic));
        return this;
    }

    public CqMsg record(String file, int magic, int cache, int proxy, int timeout) {
        this.add(String.format("[CQ:record,file=%s,magic=%d,cache=%d,proxy=%d,timeout=%d]", this.escape(file), magic, cache, proxy, timeout));
        return this;
    }

    public CqMsg video(String file, String cover, int downloadThreadNum) {
        this.add(String.format("[CQ:video,file=%s,cover=%s,c=%d]", this.escape(file), this.escape(cover), downloadThreadNum));
        return this;
    }

    public CqMsg video(String file, String cover) {
        this.add(String.format("[CQ:video,file=%s,cover=%s]", this.escape(file), this.escape(cover)));
        return this;
    }

    public CqMsg video(String file) {
        this.add(String.format("[CQ:video,file=%s]", this.escape(file)));
        return this;
    }

    public CqMsg at(long qq) {
        this.add(String.format("[CQ:at,qq=%d]", qq));
        return this;
    }

    public CqMsg at(long qq, String name) {
        this.add(String.format("[CQ:at,qq=%d,name=%s]", qq, name));
        return this;
    }

    public CqMsg atAll() {
        this.add("[CQ:at,qq=all]");
        return this;
    }

    public CqMsg share(String url, String title, String content) {
        this.add(String.format("[CQ:share,url=%s,title=%s,content=%s]", this.escape(url), this.escape(title), this.escape(content)));
        return this;
    }

    public CqMsg share(String url, String title, String content, String image) {
        this.add(String.format("[CQ:share,url=%s,title=%s,content=%s,image=%s]", this.escape(url), this.escape(title), this.escape(content), this.escape(image)));
        return this;
    }

    public CqMsg music(String type, String id) {
        this.add(String.format("[CQ:music,type=%s,id=%s]", this.escape(type), id));
        return this;
    }

    public CqMsg customMusic(String subType, String url, String audio, String title, String content, String image) {
        this.add(String.format("[CQ:music,type=custom,subtype=%s,url=%s,voice=%s,title=%s,content=%s,image=%s]", this.escape(subType), this.escape(url), this.escape(audio), this.escape(title), this.escape(content), this.escape(image)));
        return this;
    }

    public CqMsg image(String file) {
        this.add(String.format("[CQ:image,file=%s]", this.escape(file)));
        return this;
    }

    public CqMsg image(String file, EImageType type, EImageSubType subType, String url, boolean cache, EImageEffect imageEffect, int c) {
        int cacheInt;
        int n = cacheInt = cache ? 1 : 0;
        if (type == EImageType.Plain) {
            this.add(String.format("[CQ:image,file=%s%s,url=%s,cache=%d,id=%d,c=%d]", this.escape(file), subType != null ? ",subType=" + (Object)((Object)subType) : "", url, cacheInt, imageEffect.getValue(), c));
        } else {
            this.add(String.format("[CQ:image,file=%s,type=%s%s,url=%s,cache=%d,id=%d,c=%d]", this.escape(file), type.getTypeString(), subType != null ? ",subType=" + (Object)((Object)subType) : "", url, cacheInt, imageEffect.getValue(), c));
        }
        return this;
    }

    public CqMsg reply(int id) {
        this.add(String.format("[CQ:reply,id=%d]", id));
        return this;
    }

    public CqMsg reply(String text, long qq, long time, long seq) {
        this.add(String.format("[CQ:reply,text=%s,qq=%d,time=%d,seq=%d]", text, qq, time, seq));
        return this;
    }

    public CqMsg poke(long qq) {
        this.add(String.format("[CQ:poke,qq=%d]", qq));
        return this;
    }

    public CqMsg gift(long qq, EGiftType id) {
        this.add(String.format("[CQ:gift,qq=%d,id=%s]", qq, id.name()));
        return this;
    }

    public CqMsg node(int id) {
        this.add(String.format("[CQ:node,id=%d]", id));
        return this;
    }

    public CqMsg node(String name, long uin, String content, String seq) {
        this.add(String.format("[CQ:node,name=%s,uin=%d,content=%s,seq=%s]", name, uin, this.escape(content), seq));
        return this;
    }

    public CqMsg xml(String data) {
        this.add(String.format("[CQ:xml,data=%s]", data));
        return this;
    }

    public CqMsg json(String data) {
        this.add(String.format("[CQ:json,data=%s]", this.escape(data)));
        return this;
    }

    public CqMsg json(String data, int resId) {
        this.add(String.format("[CQ:json,data=%s,resid=%d]", this.escape(data), resId));
        return this;
    }

    public CqMsg cardImage(String file) {
        this.add(String.format("[CQ:cardimage,file=%s]", file));
        return this;
    }

    public CqMsg cardImage(String file, long minWidth, long minHeight, long maxWidth, long maxHeight, String source, String icon) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("[CQ:cardimage,file=%s,minwidth=%d,minheight=%d,maxwidth=%d,maxheight=%d", file, minWidth, minHeight, maxWidth, maxHeight));
        if (source != null) {
            sb.append(String.format(",source=%s", source));
        }
        if (icon != null) {
            sb.append(String.format(",icon=%s", icon));
        }
        sb.append("]");
        this.add(sb.toString());
        return this;
    }

    public CqMsg tts(String text) {
        this.add(String.format("[CQ:tts,text=%s]", this.escape(text)));
        return this;
    }

    @Override
    public String toString() {
        return String.join((CharSequence)"", this);
    }
}

