/*
 * Decompiled with CFR 0.152.
 */
package cn.svipbot.gocq.handler;

import cn.svipbot.gocq.bot.Bot;
import cn.svipbot.gocq.bot.BotPlugin;
import cn.svipbot.gocq.config.BotProperties;
import cn.svipbot.gocq.event.message.GroupMessageEvent;
import cn.svipbot.gocq.event.message.PrivateMessageEvent;
import cn.svipbot.gocq.event.meta.HeartbeatMetaEvent;
import cn.svipbot.gocq.event.meta.LifecycleMetaEvent;
import cn.svipbot.gocq.event.notice.ClientStatusNoticeEvent;
import cn.svipbot.gocq.event.notice.FriendAddNoticeEvent;
import cn.svipbot.gocq.event.notice.FriendPokeNoticeEvent;
import cn.svipbot.gocq.event.notice.FriendRecallNoticeEvent;
import cn.svipbot.gocq.event.notice.GroupAdminNoticeEvent;
import cn.svipbot.gocq.event.notice.GroupBanNoticeEvent;
import cn.svipbot.gocq.event.notice.GroupCardNoticeEvent;
import cn.svipbot.gocq.event.notice.GroupDecreaseNoticeEvent;
import cn.svipbot.gocq.event.notice.GroupEssenceNoticeEvent;
import cn.svipbot.gocq.event.notice.GroupHonorNoticeEvent;
import cn.svipbot.gocq.event.notice.GroupIncreaseNoticeEvent;
import cn.svipbot.gocq.event.notice.GroupLuckyKingNoticeEvent;
import cn.svipbot.gocq.event.notice.GroupPokeNoticeEvent;
import cn.svipbot.gocq.event.notice.GroupRecallNoticeEvent;
import cn.svipbot.gocq.event.notice.GroupTitleNoticeEvent;
import cn.svipbot.gocq.event.notice.GroupUploadNoticeEvent;
import cn.svipbot.gocq.event.notice.OfflineFileNoticeEvent;
import cn.svipbot.gocq.event.request.FriendRequestEvent;
import cn.svipbot.gocq.event.request.GroupRequestEvent;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class EventHandler {
    private static final Logger log = LoggerFactory.getLogger(EventHandler.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private BotProperties botProperties;

    private <T> T getPlugin(Class<T> clazz) {
        try {
            return (T)this.applicationContext.getBean(clazz);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u63d2\u4ef6\uff1a{}\u51fa\u9519", (Object)clazz.getName(), (Object)e);
            return null;
        }
    }

    public void handle(Bot bot, JSONObject eventJson) {
        String postTypeStr;
        switch (postTypeStr = eventJson.getString("post_type")) {
            case "message": {
                this.handleMessage(bot, eventJson);
                break;
            }
            case "message_sent": {
                this.handleMySelfMessage(bot, eventJson);
                break;
            }
            case "notice": {
                this.handleNotice(bot, eventJson);
                break;
            }
            case "request": {
                this.handleRequest(bot, eventJson);
                break;
            }
            case "meta_event": {
                this.handleMeta(bot, eventJson);
                break;
            }
            default: {
                log.warn("Unknown post type: {}", (Object)eventJson);
            }
        }
    }

    private void handleMessage(Bot bot, JSONObject eventJson) {
        String messageTypeStr;
        switch (messageTypeStr = eventJson.getString("message_type")) {
            case "private": {
                PrivateMessageEvent event = (PrivateMessageEvent)eventJson.toJavaObject(PrivateMessageEvent.class, new JSONReader.Feature[0]);
                this.handlePluginMessages(plugin -> plugin.onPrivateMessage(bot, event));
                break;
            }
            case "group": {
                GroupMessageEvent event = (GroupMessageEvent)eventJson.toJavaObject(GroupMessageEvent.class, new JSONReader.Feature[0]);
                this.handlePluginMessages(plugin -> plugin.onGroupMessage(bot, event));
                break;
            }
            default: {
                log.warn("Unknown message type: {}", (Object)eventJson);
            }
        }
    }

    private void handleMySelfMessage(Bot bot, JSONObject eventJson) {
        String messageTypeStr;
        switch (messageTypeStr = eventJson.getString("message_type")) {
            case "private": {
                PrivateMessageEvent event = (PrivateMessageEvent)eventJson.toJavaObject(PrivateMessageEvent.class, new JSONReader.Feature[0]);
                this.handlePluginMessages(plugin -> plugin.onPrivateMySelfMessage(bot, event));
                break;
            }
            case "group": {
                GroupMessageEvent event = (GroupMessageEvent)eventJson.toJavaObject(GroupMessageEvent.class, new JSONReader.Feature[0]);
                this.handlePluginMessages(plugin -> plugin.onGroupMySelfMessage(bot, event));
                break;
            }
            default: {
                log.warn("Unknown message type: {}", (Object)eventJson);
            }
        }
    }

    private void handleNotice(Bot bot, JSONObject eventJson) {
        String noticeTypeStr;
        switch (noticeTypeStr = eventJson.getString("notice_type")) {
            case "group_upload": {
                GroupUploadNoticeEvent groupUploadEvent = (GroupUploadNoticeEvent)eventJson.toJavaObject(GroupUploadNoticeEvent.class, new JSONReader.Feature[0]);
                this.handlePluginMessages(plugin -> plugin.onGroupUploadNotice(bot, groupUploadEvent));
                break;
            }
            case "group_admin": {
                GroupAdminNoticeEvent groupAdminEvent = (GroupAdminNoticeEvent)eventJson.toJavaObject(GroupAdminNoticeEvent.class, new JSONReader.Feature[0]);
                this.handlePluginMessages(plugin -> plugin.onGroupAdminNotice(bot, groupAdminEvent));
                break;
            }
            case "group_decrease": {
                GroupDecreaseNoticeEvent groupDecreaseEvent = (GroupDecreaseNoticeEvent)eventJson.toJavaObject(GroupDecreaseNoticeEvent.class, new JSONReader.Feature[0]);
                this.handlePluginMessages(plugin -> plugin.onGroupDecreaseNotice(bot, groupDecreaseEvent));
                break;
            }
            case "group_increase": {
                GroupIncreaseNoticeEvent groupIncreaseEvent = (GroupIncreaseNoticeEvent)eventJson.toJavaObject(GroupIncreaseNoticeEvent.class, new JSONReader.Feature[0]);
                this.handlePluginMessages(plugin -> plugin.onGroupIncreaseNotice(bot, groupIncreaseEvent));
                break;
            }
            case "group_ban": {
                GroupBanNoticeEvent groupBanEvent = (GroupBanNoticeEvent)eventJson.toJavaObject(GroupBanNoticeEvent.class, new JSONReader.Feature[0]);
                this.handlePluginMessages(plugin -> plugin.onGroupBanNotice(bot, groupBanEvent));
                break;
            }
            case "friend_add": {
                FriendAddNoticeEvent friendAddEvent = (FriendAddNoticeEvent)eventJson.toJavaObject(FriendAddNoticeEvent.class, new JSONReader.Feature[0]);
                this.handlePluginMessages(plugin -> plugin.onFriendAddNotice(bot, friendAddEvent));
                break;
            }
            case "group_recall": {
                GroupRecallNoticeEvent groupRecallEvent = (GroupRecallNoticeEvent)eventJson.toJavaObject(GroupRecallNoticeEvent.class, new JSONReader.Feature[0]);
                this.handlePluginMessages(plugin -> plugin.onGroupRecallNotice(bot, groupRecallEvent));
                break;
            }
            case "friend_recall": {
                FriendRecallNoticeEvent friendRecallEvent = (FriendRecallNoticeEvent)eventJson.toJavaObject(FriendRecallNoticeEvent.class, new JSONReader.Feature[0]);
                this.handlePluginMessages(plugin -> plugin.onFriendRecallNotice(bot, friendRecallEvent));
                break;
            }
            case "group_card": {
                GroupCardNoticeEvent groupCardEvent = (GroupCardNoticeEvent)eventJson.toJavaObject(GroupCardNoticeEvent.class, new JSONReader.Feature[0]);
                this.handlePluginMessages(plugin -> plugin.onGroupCardNotice(bot, groupCardEvent));
                break;
            }
            case "offline_file": {
                OfflineFileNoticeEvent offlineFileEvent = (OfflineFileNoticeEvent)eventJson.toJavaObject(OfflineFileNoticeEvent.class, new JSONReader.Feature[0]);
                this.handlePluginMessages(plugin -> plugin.onOfflineFileNotice(bot, offlineFileEvent));
                break;
            }
            case "client_status": {
                ClientStatusNoticeEvent clientStatusEvent = (ClientStatusNoticeEvent)eventJson.toJavaObject(ClientStatusNoticeEvent.class, new JSONReader.Feature[0]);
                this.handlePluginMessages(plugin -> plugin.onClientStatusNotice(bot, clientStatusEvent));
                break;
            }
            case "essence": {
                GroupEssenceNoticeEvent groupEssenceEvent = (GroupEssenceNoticeEvent)eventJson.toJavaObject(GroupEssenceNoticeEvent.class, new JSONReader.Feature[0]);
                this.handlePluginMessages(plugin -> plugin.onGroupEssenceNotice(bot, groupEssenceEvent));
                break;
            }
            case "notify": {
                this.handleNotify(bot, eventJson);
                break;
            }
            default: {
                log.warn("Unknown notice type: {}", (Object)eventJson);
            }
        }
    }

    private void handleRequest(Bot bot, JSONObject eventJson) {
        String requestTypeStr;
        switch (requestTypeStr = eventJson.getString("request_type")) {
            case "friend": {
                FriendRequestEvent friendRequestEvent = (FriendRequestEvent)eventJson.toJavaObject(FriendRequestEvent.class, new JSONReader.Feature[0]);
                this.handlePluginMessages(plugin -> plugin.onFriendRequest(bot, friendRequestEvent));
                break;
            }
            case "group": {
                GroupRequestEvent groupRequestEvent = (GroupRequestEvent)eventJson.toJavaObject(GroupRequestEvent.class, new JSONReader.Feature[0]);
                this.handlePluginMessages(plugin -> plugin.onGroupRequest(bot, groupRequestEvent));
                break;
            }
            default: {
                log.warn("Unknown request type: {}", (Object)eventJson);
            }
        }
    }

    private void handleMeta(Bot bot, JSONObject eventJson) {
        String metaEventTypeStr;
        switch (metaEventTypeStr = eventJson.getString("meta_event_type")) {
            case "heartbeat": {
                HeartbeatMetaEvent heartbeatEvent = (HeartbeatMetaEvent)eventJson.toJavaObject(HeartbeatMetaEvent.class, new JSONReader.Feature[0]);
                this.handlePluginMessages(plugin -> plugin.onHeartbeatMeta(bot, heartbeatEvent));
                break;
            }
            case "lifecycle": {
                LifecycleMetaEvent lifecycleEvent = (LifecycleMetaEvent)eventJson.toJavaObject(LifecycleMetaEvent.class, new JSONReader.Feature[0]);
                this.handlePluginMessages(plugin -> plugin.onLifecycleMeta(bot, lifecycleEvent));
                break;
            }
            default: {
                log.warn("Unknown meta type: {}", (Object)eventJson);
            }
        }
    }

    private void handleNotify(Bot bot, JSONObject eventJson) {
        String subTypeStr;
        switch (subTypeStr = eventJson.getString("sub_type")) {
            case "honor": {
                GroupHonorNoticeEvent groupHonorEvent = (GroupHonorNoticeEvent)eventJson.toJavaObject(GroupHonorNoticeEvent.class, new JSONReader.Feature[0]);
                this.handlePluginMessages(plugin -> plugin.onGroupHonorNotice(bot, groupHonorEvent));
                break;
            }
            case "poke": {
                this.handlePoke(bot, eventJson);
                break;
            }
            case "title": {
                GroupTitleNoticeEvent groupTitleEvent = (GroupTitleNoticeEvent)eventJson.toJavaObject(GroupTitleNoticeEvent.class, new JSONReader.Feature[0]);
                this.handlePluginMessages(plugin -> plugin.onGroupTitleNotice(bot, groupTitleEvent));
                break;
            }
            case "lucky_king": {
                GroupLuckyKingNoticeEvent groupLuckyKingEvent = (GroupLuckyKingNoticeEvent)eventJson.toJavaObject(GroupLuckyKingNoticeEvent.class, new JSONReader.Feature[0]);
                this.handlePluginMessages(plugin -> plugin.onGroupLuckyKingNotice(bot, groupLuckyKingEvent));
                break;
            }
            default: {
                log.warn("Unknown notify type: {}", (Object)eventJson);
            }
        }
    }

    private void handlePoke(Bot bot, JSONObject eventJson) {
        if (eventJson.containsKey("group_id")) {
            GroupPokeNoticeEvent event = (GroupPokeNoticeEvent)eventJson.toJavaObject(GroupPokeNoticeEvent.class, new JSONReader.Feature[0]);
            this.handlePluginMessages(plugin -> plugin.onGroupPokeNotice(bot, event));
        } else {
            FriendPokeNoticeEvent event = (FriendPokeNoticeEvent)eventJson.toJavaObject(FriendPokeNoticeEvent.class, new JSONReader.Feature[0]);
            this.handlePluginMessages(plugin -> plugin.onFriendPokeNotice(bot, event));
        }
    }

    private void handlePluginMessages(Function<BotPlugin, Integer> action) {
        for (Class<? extends BotPlugin> pluginClass : this.botProperties.getPluginList()) {
            BotPlugin plugin = this.getPlugin(pluginClass);
            if (plugin == null || action.apply(plugin) != 0) continue;
            return;
        }
    }
}

